/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util.helper;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailMessageItemAttachment;
import tnt.tarkovcraft.core.common.mail.MailSource;
import tnt.tarkovcraft.core.common.mail.MailSystem;
import tnt.tarkovcraft.core.util.CommonLabels;

public final class PlayerHelper {
    public static void giveItem(ItemStack itemStack, Player player) {
        PlayerHelper.giveItem(itemStack, player, false);
    }

    public static void giveItem(ItemStack itemStack, Player player, boolean receiveInMail) {
        PlayerHelper.giveItem(itemStack, player, receiveInMail, true);
    }

    public static void giveItem(ItemStack itemstack, Player player, boolean receiveInMail, boolean storeInMailOnError) {
        if (player.level().isClientSide()) {
            return;
        }
        if (MailSystem.isEnabled() && receiveInMail) {
            MailSystem.sendMessage(player, MailSource.SYSTEM, MailMessage.system(CommonLabels.MESSAGE_ITEM_RECEIVED).attachment(MailMessageItemAttachment.item(itemstack.copy())));
        } else if (!player.addItem(itemstack)) {
            Vec3 pos = player.position();
            ItemEntity itemEntity = new ItemEntity(player.level(), pos.x(), pos.y(), pos.z(), itemstack.copy());
            itemEntity.setTarget(player.getUUID());
            itemEntity.setNoPickUpDelay();
            if (!player.level().addFreshEntity((Entity)itemEntity)) {
                if (MailSystem.isEnabled() && storeInMailOnError) {
                    MailSystem.sendMessage(player, MailSource.SYSTEM, MailMessage.system(CommonLabels.MESSAGE_ITEM_RECEIVED).attachment(MailMessageItemAttachment.item(itemstack.copy())));
                    TarkovCraftCore.LOGGER.error(TarkovCraftCore.MARKER, "Failed to create item drop entity {} for player {}, sending as mail instead", (Object)itemEntity, (Object)player);
                    return;
                }
                TarkovCraftCore.LOGGER.error(TarkovCraftCore.MARKER, "Failed to create item drop entity {} for player {}", (Object)itemEntity, (Object)player);
            }
        }
    }
}

