/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.core.client.screen.listener.ScrollChangeListener;
import tnt.tarkovcraft.core.client.screen.widget.Scrollable;
import tnt.tarkovcraft.core.util.helper.MathHelper;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class ListWidget<T extends AbstractWidget>
extends AbstractWidget
implements Scrollable {
    private final List<T> items;
    private double scroll;
    private ScrollChangeListener scrollListener;
    private int additionalItemSpacing = 0;
    private int backgroundColor;

    public <SRC> ListWidget(int x, int y, int width, int height, List<SRC> items, ListWidgetItemBuilder<T, SRC> builder) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.items = new ArrayList<T>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            T item = builder.buildItem(items.get(i), i);
            this.items.add(item);
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setAdditionalItemSpacing(int additionalItemSpacing) {
        this.additionalItemSpacing = additionalItemSpacing;
    }

    public void setScrollListener(ScrollChangeListener scrollListener) {
        this.scrollListener = scrollListener;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        if (RenderUtils.isVisibleColor(this.backgroundColor)) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), this.backgroundColor);
        }
        boolean wasVisible = false;
        for (AbstractWidget item : this.getItems()) {
            int oldY = item.getY();
            item.setY(this.getY() + oldY - (int)this.scroll);
            if (!this.isItemVisible(item)) {
                item.setY(oldY);
                if (!wasVisible) continue;
                break;
            }
            wasVisible = true;
            item.render(guiGraphics, mouseX, mouseY, partialTick);
            item.setY(oldY);
        }
        guiGraphics.disableScissor();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        T item = this.getItemAt(mouseX, mouseY);
        if (item != null && item.isMouseOver(mouseX, mouseY) && item.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        double oldScroll = this.scroll;
        this.scroll = Scrollable.scroll(this, scrollY);
        if (this.scrollListener != null && oldScroll != this.scroll) {
            this.scrollListener.onScrollChange(scrollX, this.scroll);
        }
        return oldScroll != this.scroll;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        T item = this.getItemAt(event.x(), event.y());
        return item != null && item.mouseClicked(event, doubleClick);
    }

    public T getItemAt(double x, double y) {
        for (AbstractWidget item : this.getItems()) {
            if (!item.isMouseOver(x, y - this.scroll)) continue;
            return (T)item;
        }
        return null;
    }

    public boolean isItemVisible(T item) {
        return MathHelper.areaOverlapsPartial(item.getX(), item.getY(), item.getWidth(), item.getHeight(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public List<T> getItems() {
        return this.items;
    }

    @Override
    public double getScroll() {
        return this.scroll;
    }

    @Override
    public double getMaxScroll() {
        double totalItemsHeight = this.getTotalSize();
        return Math.max(0.0, totalItemsHeight - this.getVisibleSize() + (double)(2 * this.additionalItemSpacing));
    }

    @Override
    public double getTotalSize() {
        return this.getItems().stream().mapToInt(w -> w.getHeight() + this.additionalItemSpacing).sum();
    }

    @Override
    public void setScroll(double scroll) {
        this.scroll = Mth.clamp((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    @Override
    public double getVisibleSize() {
        return this.height;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @FunctionalInterface
    public static interface ListWidgetItemBuilder<T extends AbstractWidget, SRC> {
        public T buildItem(SRC var1, int var2);
    }
}

