/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.energy;

import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.core.api.ArmStaminaComponent;
import tnt.tarkovcraft.core.api.MovementStaminaComponent;
import tnt.tarkovcraft.core.api.StaminaComponent;
import tnt.tarkovcraft.core.api.event.StaminaEvent;
import tnt.tarkovcraft.core.common.energy.DefaultMovementStaminaComponent;
import tnt.tarkovcraft.core.common.energy.NoArmStaminaComponent;
import tnt.tarkovcraft.core.compatibility.Component;

public final class EnergySystem {
    public static final Component<MovementStaminaComponent> MOVEMENT_STAMINA = new Component<DefaultMovementStaminaComponent>("Movement Stamina", DefaultMovementStaminaComponent.INSTANCE);
    public static final Component<ArmStaminaComponent> ARM_STAMINA = new Component<NoArmStaminaComponent>("Arm Stamina", NoArmStaminaComponent.INSTANCE);

    public static Boolean canSprint(LivingEntity entity) {
        StaminaEvent.CanSprint event = (StaminaEvent.CanSprint)NeoForge.EVENT_BUS.post((Event)new StaminaEvent.CanSprint(MOVEMENT_STAMINA.getComponent(), entity));
        return event.canSprint();
    }

    public static void onSprinted(LivingEntity entity) {
        NeoForge.EVENT_BUS.post((Event)new StaminaEvent.AfterSprint(MOVEMENT_STAMINA.getComponent(), entity));
    }

    public static Boolean canJump(LivingEntity entity) {
        StaminaEvent.CanJump event = (StaminaEvent.CanJump)NeoForge.EVENT_BUS.post((Event)new StaminaEvent.CanJump(MOVEMENT_STAMINA.getComponent(), entity));
        return event.canJump();
    }

    public static void onJumped(LivingEntity entity) {
        NeoForge.EVENT_BUS.post((Event)new StaminaEvent.AfterJump(MOVEMENT_STAMINA.getComponent(), entity));
    }

    public static float consumeEnergy(StaminaComponent component, LivingEntity entity, float baseConsumption) {
        StaminaEvent.Consuming event = (StaminaEvent.Consuming)NeoForge.EVENT_BUS.post((Event)new StaminaEvent.Consuming(component, entity, baseConsumption));
        return Math.abs(event.getConsumeAmount());
    }

    public static float recoverEnergy(StaminaComponent component, LivingEntity entity, float baseRecovery) {
        StaminaEvent.Recovering event = (StaminaEvent.Recovering)NeoForge.EVENT_BUS.post((Event)new StaminaEvent.Recovering(component, entity, baseRecovery));
        return Math.abs(event.getRecoverAmount());
    }
}

