/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProviderType;
import tnt.tarkovcraft.core.util.Codecs;

public final class SkillLevelDefinition {
    public static final SkillLevelDefinition DEFAULT = new SkillLevelDefinition((Either<NumberProvider, Integer>)Either.right((Object)100), (Either<NumberProvider, Float>)Either.right((Object)Float.valueOf(10.0f)), (Either<NumberProvider, Float>)Either.right((Object)Float.valueOf(15.0f)), (Either<NumberProvider, Integer>)Either.right((Object)Short.MAX_VALUE), (Either<NumberProvider, Float>)Either.right((Object)Float.valueOf(Float.MAX_VALUE)));
    public static final Codec<SkillLevelDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NumberProviderType.complexCodecNoDuration(ExtraCodecs.POSITIVE_INT).optionalFieldOf("maxLevel", (Object)Either.left((Object)SkillLevelDefinition.DEFAULT.maxLevel)).forGetter(t -> Either.left((Object)t.maxLevel)), (App)NumberProviderType.complexCodecNoDuration(Codecs.NON_NEGATIVE_FLOAT).optionalFieldOf("baseExperience", (Object)Either.left((Object)SkillLevelDefinition.DEFAULT.baseExperience)).forGetter(t -> Either.left((Object)t.baseExperience)), (App)NumberProviderType.complexCodecNoDuration(Codecs.NON_NEGATIVE_FLOAT).optionalFieldOf("additionalExperience", (Object)Either.left((Object)SkillLevelDefinition.DEFAULT.additionalExperience)).forGetter(t -> Either.left((Object)t.additionalExperience)), (App)NumberProviderType.complexCodecNoDuration(Codecs.NON_NEGATIVE_INT).optionalFieldOf("maxStack", (Object)Either.left((Object)SkillLevelDefinition.DEFAULT.maxStack)).forGetter(t -> Either.left((Object)t.maxLevel)), (App)NumberProviderType.complexCodecNoDuration(Codecs.NON_NEGATIVE_FLOAT).optionalFieldOf("maxExperience", (Object)Either.left((Object)SkillLevelDefinition.DEFAULT.maxExperience)).forGetter(t -> Either.left((Object)t.maxExperience))).apply((Applicative)instance, SkillLevelDefinition::new));
    private final NumberProvider maxLevel;
    private final NumberProvider baseExperience;
    private final NumberProvider additionalExperience;
    private final NumberProvider maxStack;
    private final NumberProvider maxExperience;

    public SkillLevelDefinition(Either<NumberProvider, Integer> maxLevel, Either<NumberProvider, Float> baseExperience, Either<NumberProvider, Float> additionalExperience, Either<NumberProvider, Integer> maxStack, Either<NumberProvider, Float> maxExperience) {
        this.maxLevel = NumberProviderType.resolveNoDuration(maxLevel);
        this.baseExperience = NumberProviderType.resolveNoDuration(baseExperience);
        this.additionalExperience = NumberProviderType.resolveNoDuration(additionalExperience);
        this.maxStack = NumberProviderType.resolveNoDuration(maxStack);
        this.maxExperience = NumberProviderType.resolveNoDuration(maxExperience);
    }

    public int getMaxLevel() {
        return Math.max(0, this.maxLevel.intValue());
    }

    public float getRequiredExperience(int level) {
        int stackMultiplier = Mth.clamp((int)level, (int)0, (int)this.maxStack.intValue());
        float baseExperience = Math.max(0.0f, this.baseExperience.floatValue());
        float additionalExperience = Math.max(0.0f, this.additionalExperience.floatValue());
        return Math.min(baseExperience + additionalExperience * (float)stackMultiplier, this.maxExperience.floatValue());
    }
}

