/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.weight;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.api.event.EntityWeightUpdateEvent;
import tnt.tarkovcraft.core.api.event.RegisterWeightProvidersEvent;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.config.WeightConfig;
import tnt.tarkovcraft.core.common.init.CoreAttributes;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreItemDataComponents;
import tnt.tarkovcraft.core.common.weight.WeightContext;
import tnt.tarkovcraft.core.common.weight.WeightProvider;
import tnt.tarkovcraft.core.common.weight.provider.BundleWeightProvider;
import tnt.tarkovcraft.core.common.weight.provider.ContainerWeightProvider;
import tnt.tarkovcraft.core.common.weight.provider.CurrencyWeightProvider;
import tnt.tarkovcraft.core.common.weight.provider.EntityEquipmentWeightProvider;
import tnt.tarkovcraft.core.common.weight.provider.PlayerInventoryWeightProvider;

public class WeightSystem {
    public static final WeightSystem INSTANCE = new WeightSystem();
    public static final DecimalFormat FORMAT = new DecimalFormat("0.###");
    public static final Marker MARKER = MarkerManager.getMarker((String)"WeightSystem");
    public static final ResourceLocation OVERWEIGHT_ATTRIBUTE_MODIFIER = TarkovCraftCore.createResourceLocation("overweight");
    public static final BiFunction<Integer, Style, Style> BASE_LABEL_STYLE = (weight, style) -> style.withColor(ChatFormatting.GRAY);
    public static final BiFunction<Integer, Style, Style> BASE_VALUE_STYLE = (weight, style) -> style.withColor(ChatFormatting.YELLOW);
    public static final BiFunction<Integer, Style, Style> NO_STYLE = (weight, style) -> style;
    private final Map<ResourceLocation, WeightProvider> providerMap = new HashMap<ResourceLocation, WeightProvider>();
    private final Multimap<WeightProvider.WeightSource, WeightProvider> typeProviderMap = ArrayListMultimap.create();

    public static boolean isEnabled() {
        return TarkovCraftCore.getConfig().weightConfig.enableWeightSystem;
    }

    public static boolean isContainerWeightEnabled() {
        return TarkovCraftCore.getConfig().weightConfig.calculateContainerWeight;
    }

    public static int getItemWeight(ItemStack itemStack) {
        return INSTANCE.getWeight(itemStack);
    }

    public static int getWeight(LivingEntity entity) {
        return entity.hasData(CoreDataAttachments.WEIGHT) ? (Integer)entity.getData(CoreDataAttachments.WEIGHT) : 0;
    }

    public static boolean isOverweight(LivingEntity entity) {
        int weight = WeightSystem.getWeight(entity);
        int limit = AttributeSystem.getIntValue((Entity)entity, CoreAttributes.WEIGHT_LIMIT, 0);
        return limit > 0 && weight > limit;
    }

    public static float getOverweightEffectFactor(LivingEntity entity) {
        int weight = WeightSystem.getWeight(entity);
        int limit = AttributeSystem.getIntValue((Entity)entity, CoreAttributes.WEIGHT_LIMIT, 0);
        if (limit <= 0 || weight <= limit) {
            return 0.0f;
        }
        float factor = (float)(weight - limit) / (float)limit;
        float attributeFactor = AttributeSystem.getFloatValue((Entity)entity, CoreAttributes.WEIGHT_EFFECT_FACTOR, 1.0f);
        return factor * attributeFactor;
    }

    public static void applyWeightEffects(LivingEntity entity) {
        if (!WeightSystem.isEnabled()) {
            return;
        }
        int weight = INSTANCE.calculateWeight(entity);
        int originalWeight = WeightSystem.getWeight(entity);
        entity.setData(CoreDataAttachments.WEIGHT, (Object)weight);
        float factor = WeightSystem.getOverweightEffectFactor(entity);
        WeightConfig config = TarkovCraftCore.getConfig().weightConfig;
        WeightSystem.updateVanillaAttributeModifier(entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, config.overweightSpeedReduction, factor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        WeightSystem.updateVanillaAttributeModifier(entity, (Holder<Attribute>)Attributes.JUMP_STRENGTH, config.overweightJumpReduction, factor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        WeightSystem.updateVanillaAttributeModifier(entity, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, config.overweightSafeFallDistanceReduction, factor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        WeightSystem.updateVanillaAttributeModifier(entity, (Holder<Attribute>)Attributes.STEP_HEIGHT, config.overweightStepHeightReduction, factor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        NeoForge.EVENT_BUS.post((Event)new EntityWeightUpdateEvent(entity, originalWeight, weight, factor));
    }

    public static Component getWeightDisplay(int weight, BiFunction<Integer, Style, Style> baseStyleApplicator, BiFunction<Integer, Style, Style> weightStyleApplicator) {
        Component weightLabel = WeightSystem.getWeightValueDisplay(weight, weightStyleApplicator);
        return Component.translatable((String)"label.tarkovcraft_core.weight", (Object[])new Object[]{weightLabel}).withStyle(style -> (Style)baseStyleApplicator.apply(weight, (Style)style));
    }

    public static Component getWeightValueDisplay(int weight, BiFunction<Integer, Style, Style> weightStyleApplicator) {
        String unitSuffix = weight < 1000 ? "g" : "kg";
        float unit = weight < 1000 ? 1.0f : 1000.0f;
        MutableComponent weightComponent = Component.literal((String)FORMAT.format((float)weight / unit)).withStyle(style -> (Style)weightStyleApplicator.apply(weight, (Style)style));
        return Component.translatable((String)("label.tarkovcraft_core.weight.unit." + unitSuffix), (Object[])new Object[]{weightComponent}).withStyle(style -> (Style)weightStyleApplicator.apply(weight, (Style)style));
    }

    public static Component getWeightDisplay(int weight) {
        return WeightSystem.getWeightDisplay(weight, BASE_LABEL_STYLE, BASE_VALUE_STYLE);
    }

    public static void updateVanillaAttributeModifier(LivingEntity entity, Holder<Attribute> attribute, double amount, float factor, AttributeModifier.Operation operation) {
        AttributeInstance instance = entity.getAttribute(attribute);
        if (instance.hasModifier(OVERWEIGHT_ATTRIBUTE_MODIFIER)) {
            instance.removeModifier(OVERWEIGHT_ATTRIBUTE_MODIFIER);
        }
        if (factor > 0.0f) {
            AttributeModifier modifier = new AttributeModifier(OVERWEIGHT_ATTRIBUTE_MODIFIER, amount * (double)factor, operation);
            instance.addTransientModifier(modifier);
        }
    }

    public int getWeight(ItemStack itemStack) {
        if (!WeightSystem.isEnabled()) {
            return 0;
        }
        int count = itemStack.getCount();
        int baseWeight = (Integer)itemStack.getOrDefault(CoreItemDataComponents.WEIGHT, (Object)0);
        int weight = count * baseWeight;
        if (WeightSystem.isContainerWeightEnabled()) {
            Collection additionalWeightProviders = this.typeProviderMap.get((Object)WeightProvider.WeightSource.ITEM);
            WeightContext itemCtx = WeightContext.itemStack(baseWeight, itemStack, this::getWeight);
            for (WeightProvider provider : additionalWeightProviders) {
                weight += count * provider.getWeight(itemCtx);
            }
        }
        return weight;
    }

    public int calculateWeight(LivingEntity entity) {
        if (!WeightSystem.isEnabled()) {
            return 0;
        }
        int weight = 0;
        Collection additionalInventoryProviders = this.typeProviderMap.get((Object)WeightProvider.WeightSource.ENTITY);
        WeightContext entityCtx = WeightContext.entity(entity, this::getWeight);
        for (WeightProvider provider : additionalInventoryProviders) {
            weight += provider.getWeight(entityCtx);
        }
        return weight;
    }

    @ApiStatus.Internal
    public void init() {
        if (!this.providerMap.isEmpty()) {
            throw new IllegalStateException("Already initialized");
        }
        ModLoader.postEvent((Event)new RegisterWeightProvidersEvent(this::register));
    }

    @ApiStatus.Internal
    public void registerDefaultProviders(RegisterWeightProvidersEvent event) {
        event.register(BundleWeightProvider.IDENTIFIER, new BundleWeightProvider());
        event.register(CurrencyWeightProvider.IDENTIFIER, new CurrencyWeightProvider());
        event.register(ContainerWeightProvider.IDENTIFIER, new ContainerWeightProvider());
        event.register(EntityEquipmentWeightProvider.IDENTIFIER, new EntityEquipmentWeightProvider());
        event.register(PlayerInventoryWeightProvider.IDENTIFIER, new PlayerInventoryWeightProvider());
    }

    private synchronized void register(ResourceLocation id, WeightProvider provider) {
        if (this.providerMap.putIfAbsent(Objects.requireNonNull(id), Objects.requireNonNull(provider)) != null) {
            TarkovCraftCore.LOGGER.error(MARKER, "Detected attempted weight provider override for ID {}, value '{}', skipping registration!", (Object)id, (Object)provider.getClass().getCanonicalName());
            return;
        }
        WeightProvider.WeightSource source = provider.getSource();
        this.typeProviderMap.put((Object)source, (Object)provider);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        FORMAT.setDecimalFormatSymbols(symbols);
    }
}

