/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.network.message;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.client.TarkovCraftCoreClient;
import tnt.tarkovcraft.core.network.Synchronizable;
import tnt.tarkovcraft.core.network.TarkovCraftCoreNetwork;

public class S2C_SendDataAttachments
implements CustomPacketPayload {
    public static final ResourceLocation ID = TarkovCraftCoreNetwork.createId(S2C_SendDataAttachments.class);
    public static final CustomPacketPayload.Type<S2C_SendDataAttachments> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, S2C_SendDataAttachments> CODEC = StreamCodec.of(S2C_SendDataAttachments::encode, S2C_SendDataAttachments::new);
    private final int entityId;
    private final List<ResourceLocation> attachments;
    private final CompoundTag data;

    public S2C_SendDataAttachments(Entity entity, AttachmentType<? extends Synchronizable<?>> type) {
        this(entity, Collections.singletonList(type));
    }

    public <T extends Synchronizable<T>> S2C_SendDataAttachments(Entity entity, List<AttachmentType<? extends Synchronizable<?>>> types) {
        this.entityId = entity.getId();
        this.attachments = new ArrayList<ResourceLocation>(types.size());
        this.data = new CompoundTag();
        RegistryAccess access = entity.registryAccess();
        RegistryOps ops = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ArrayList<SerializableHolder<Synchronizable>> serializables = new ArrayList<SerializableHolder<Synchronizable>>();
        for (AttachmentType<Synchronizable<?>> attachmentType : types) {
            ResourceLocation typeIdentifier = NeoForgeRegistries.ATTACHMENT_TYPES.getKey(attachmentType);
            this.attachments.add(typeIdentifier);
            Synchronizable serializable = (Synchronizable)entity.getData(attachmentType);
            serializable.preSyncPrepare();
            serializables.add(new SerializableHolder<Synchronizable>(typeIdentifier, serializable));
        }
        for (SerializableHolder serializableHolder : serializables) {
            Synchronizable serializable = (Synchronizable)serializableHolder.serializable();
            Codec networkCodec = serializable.networkCodec();
            Tag tag = (Tag)networkCodec.encodeStart((DynamicOps)ops, (Object)serializable).getOrThrow();
            ResourceLocation identifier = serializableHolder.id();
            this.data.put(identifier.toString(), tag);
        }
    }

    private S2C_SendDataAttachments(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        int count = buf.readInt();
        this.attachments = new ArrayList<ResourceLocation>(count);
        for (int i = 0; i < count; ++i) {
            ResourceLocation key = buf.readResourceLocation();
            this.attachments.add(key);
        }
        this.data = buf.readNbt();
    }

    public <T extends Synchronizable<T>> void handleMessage(IPayloadContext ctx) {
        Player player = ctx.player();
        Level level = player.level();
        Entity entity = level.getEntity(this.entityId);
        if (entity == null) {
            TarkovCraftCore.LOGGER.warn(TarkovCraftCore.MARKER, "Entity not found in level by ID: {}", (Object)this.entityId);
            return;
        }
        RegistryOps ops = entity.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (ResourceLocation attachment : this.attachments) {
            AttachmentType type = (AttachmentType)NeoForgeRegistries.ATTACHMENT_TYPES.getValue(attachment);
            Synchronizable value = (Synchronizable)entity.getData(type);
            Codec codec = value.networkCodec();
            Synchronizable data = (Synchronizable)codec.parse((DynamicOps)ops, (Object)this.data.getCompoundOrEmpty(attachment.toString())).getPartialOrThrow();
            entity.setData(type, (Object)data);
            TarkovCraftCoreClient.sendDataSyncEvent(entity, type, data);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static void encode(FriendlyByteBuf buffer, S2C_SendDataAttachments message) {
        buffer.writeInt(message.entityId);
        buffer.writeInt(message.attachments.size());
        message.attachments.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeResourceLocation(arg_0));
        buffer.writeNbt((Tag)message.data);
    }

    private record SerializableHolder<T>(ResourceLocation id, T serializable) {
    }
}

