/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus;

import com.provismet.cobblemon.daycareplus.api.DaycarePlusInitializer;
import com.provismet.cobblemon.daycareplus.breeding.BreedingUtils;
import com.provismet.cobblemon.daycareplus.command.DPCommands;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.config.IncubatorTiers;
import com.provismet.cobblemon.daycareplus.handler.CobblemonEventHandler;
import com.provismet.cobblemon.daycareplus.networking.callback.PacketCallbacksC2S;
import com.provismet.cobblemon.daycareplus.registries.DPItemDataComponents;
import com.provismet.cobblemon.daycareplus.registries.DPItemGroups;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.registries.DPPayloads;
import com.provismet.cobblemon.daycareplus.registries.DPStats;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaycarePlusMain
implements ModInitializer {
    public static final String MODID = "daycareplus";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Daycare+");

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    public void onInitialize() {
        DaycarePlusOptions.load();
        IncubatorTiers.load();
        PolymerResourcePackUtils.markAsRequired();
        PolymerResourcePackUtils.addModAssets((String)MODID);
        DPItems.init();
        DPItemDataComponents.init();
        DPItemGroups.register();
        DPStats.init();
        DPCommands.register();
        DPPayloads.register();
        PacketCallbacksC2S.register();
        CobblemonEventHandler.register();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new BreedingUtils());
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> CompletableFuture.runAsync(() -> IncubatorCollection.loadFromJson((class_1657)serverPlayNetworkHandler.method_32311())));
        ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, minecraftServer) -> {
            String playerUUID = serverPlayNetworkHandler.method_32311().method_5845();
            CompletableFuture.runAsync(() -> IncubatorCollection.remove(minecraftServer, playerUUID));
        });
        ServerLifecycleEvents.BEFORE_SAVE.register((minecraftServer, flush, force) -> CompletableFuture.runAsync(() -> IncubatorCollection.saveAll(minecraftServer)));
        FabricLoader.getInstance().getEntrypointContainers(MODID, DaycarePlusInitializer.class).forEach(initializer -> {
            try {
                ((DaycarePlusInitializer)initializer.getEntrypoint()).onInitialize();
            }
            catch (Throwable e) {
                LOGGER.error("Daycare+ failed to initialise sidemod entrypoint from {} due to errors provided by it:", (Object)initializer.getProvider().getMetadata().getName(), (Object)e);
            }
        });
    }
}

