/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.storage;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.cobblemon.daycareplus.storage.EggStorage;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class IncubatorCollection
implements Iterable<Map.Entry<String, EggStorage>> {
    public static final Codec<IncubatorCollection> CODEC = Codec.unboundedMap((Codec)Codec.STRING, EggStorage.CODEC).xmap(IncubatorCollection::new, IncubatorCollection::getStorageMap);
    private static final Map<String, IncubatorCollection> playerMap = new HashMap<String, IncubatorCollection>();
    private static final class_5218 INCUBATOR_SAVE_PATH = new class_5218("incubators");
    private final Map<String, EggStorage> storageMap;

    public IncubatorCollection(Map<String, EggStorage> storages) {
        this.storageMap = new HashMap<String, EggStorage>(storages);
    }

    public static IncubatorCollection getOrCreate(class_1657 player) {
        return playerMap.computeIfAbsent(player.method_5845(), string -> new IncubatorCollection(Map.of()));
    }

    public static IncubatorCollection getCollection(String uuidString) {
        return playerMap.get(uuidString);
    }

    public void put(String label, EggStorage storage) {
        this.storageMap.put(label, storage);
    }

    public Optional<EggStorage> get(String label) {
        return Optional.ofNullable(this.storageMap.get(label));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, EggStorage>> iterator() {
        return this.storageMap.entrySet().iterator();
    }

    public void saveToJson(MinecraftServer server, String ownerUUID) {
        Path savePath = server.method_27050(INCUBATOR_SAVE_PATH).resolve(ownerUUID + ".json");
        DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        result.ifSuccess(json -> {
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson(json);
            savePath.toFile().getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(savePath.toFile());){
                writer.write(jsonString);
            }
            catch (IOException e) {
                DaycarePlusMain.LOGGER.error("Failed to save incubator data for uuid: {}", (Object)ownerUUID);
                DaycarePlusMain.LOGGER.error("Incubator JSON: {}", (Object)jsonString);
                DaycarePlusMain.LOGGER.error("Stack Trace: ", (Throwable)e);
            }
        });
    }

    public static void loadFromJson(class_1657 owner) {
        class_1937 class_19372 = owner.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        Path savePath = world.method_8503().method_27050(INCUBATOR_SAVE_PATH).resolve(owner.method_5845() + ".json");
        try {
            JsonElement json = JsonParser.parseReader((Reader)new FileReader(savePath.toFile()));
            DataResult result = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            IncubatorCollection collection = result.isSuccess() ? (IncubatorCollection)((Pair)result.getOrThrow()).getFirst() : new IncubatorCollection(Map.of());
            playerMap.putIfAbsent(owner.method_5845(), collection);
        }
        catch (FileNotFoundException json) {
        }
        catch (Exception e) {
            DaycarePlusMain.LOGGER.error("Failed to read incubator file {}", (Object)savePath.toAbsolutePath());
            DaycarePlusMain.LOGGER.error("Stack Trace: ", (Throwable)e);
        }
    }

    public static void remove(MinecraftServer server, String ownerUUID) {
        IncubatorCollection collection = IncubatorCollection.getCollection(ownerUUID);
        if (collection != null) {
            playerMap.remove(ownerUUID);
            collection.saveToJson(server, ownerUUID);
        }
    }

    public static void saveAll(MinecraftServer server) {
        for (Map.Entry<String, IncubatorCollection> entry : playerMap.entrySet()) {
            entry.getValue().saveToJson(server, entry.getKey());
        }
    }

    private Map<String, EggStorage> getStorageMap() {
        return this.storageMap;
    }
}

