package com.provismet.cobblemon.daycareplus.breeding;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import net.minecraft.class_5699;

public record FormPropertiesOverride (Map<String, String> assignments) {
    public static final Codec<FormPropertiesOverride> CODEC = Codec.unboundedMap(class_5699.field_41759, class_5699.field_41759)
        .comapFlatMap(map -> DataResult.success(new FormPropertiesOverride(map)), FormPropertiesOverride::assignments);

    public String toString (String assigner, String delimiter) {
        return String.join(delimiter, this.assignments.entrySet().stream().map(entry -> entry.getKey() + assigner + entry.getValue()).toList());
    }

    @Override
    public String toString () {
        return this.toString("=", " ");
    }
}
