package com.provismet.cobblemon.daycareplus.breeding;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.CollectEggEvent;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.api.DaycarePlusEvents;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.feature.FertilityProperty;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.util.tag.DPItemTags;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PastureExtension {
    private final UUID uuid;
    private final PokemonPastureBlockEntity blockEntity;
    private long prevTime;
    private int twinBoosts;
    private int shinyBoosts;

    public PastureExtension (PokemonPastureBlockEntity blockEntity, long prevTime, UUID uuid, int twinBoosts, int shinyBoosts) {
        this.blockEntity = blockEntity;
        this.prevTime = prevTime;
        this.uuid = uuid;
        this.twinBoosts = twinBoosts;
        this.shinyBoosts = shinyBoosts;
    }

    public static PastureExtension fromNBT (PokemonPastureBlockEntity blockEntity, UUID uuid, class_2487 nbt) {
        long prevTick = Long.MAX_VALUE;
        int boosts = 0;
        int shinyBoosts = 0;
        if (nbt.method_10545("prevTick")) prevTick = nbt.method_10537("prevTick");
        if (nbt.method_10545("boosts")) boosts = nbt.method_10550("boosts");
        if (nbt.method_10545("shinyBoosts")) shinyBoosts = nbt.method_10550("shinyBoosts");

        return new PastureExtension(blockEntity, prevTick, uuid, boosts, shinyBoosts);
    }

    private void tryApplyMirrorHerb (Pokemon potentialHolder, Pokemon other) {
        if (!potentialHolder.heldItem().method_31574(CobblemonItems.MIRROR_HERB)) return;
        class_1657 owner = null;
        if (this.blockEntity.getOwnerId() != null && this.blockEntity.method_10997() != null) {
            owner = this.blockEntity.method_10997().method_18470(this.blockEntity.getOwnerId());
        }

        for (Move move : other.getMoveSet()) {
            if (potentialHolder.getForm().getMoves().getEggMoves().stream().anyMatch(moveTemplate -> moveTemplate.getName().equalsIgnoreCase(move.getName()))) {
                // Avoid relearning moves you already have.
                if (potentialHolder.getMoveSet().getMoves().stream().map(Move::getTemplate).anyMatch(moveTemplate -> moveTemplate.getName().equalsIgnoreCase(move.getName()))) {
                    continue;
                }
                boolean alreadyLearnt = false;
                for (BenchedMove benchedMove : potentialHolder.getBenchedMoves()) {
                    if (benchedMove.getMoveTemplate().getName().equalsIgnoreCase(move.getName())) {
                        alreadyLearnt = true;
                        break;
                    }
                }
                if (alreadyLearnt) continue;

                if (potentialHolder.getMoveSet().add(move.getTemplate().create()) && owner != null) {
                    owner.method_43496(class_2561.method_43469("message.chat.daycareplus.move_learnt", potentialHolder.getDisplayName(), move.getDisplayName()));
                }
            }
        }
    }

    public long getPrevTime () {
        return this.prevTime;
    }

    public int getTwinBoosts () {
        return this.twinBoosts;
    }

    public void setTwinBoosts (int twinBoosts) {
        this.twinBoosts = twinBoosts;
    }

    public int getShinyBoosts () {
        return this.shinyBoosts;
    }

    public void setShinyBoosts (int shinyBoosts) {
        this.shinyBoosts = shinyBoosts;
    }

    public Optional<PotentialPokemonProperties> predictEgg () {
        if (this.blockEntity.getTetheredPokemon().size() != 2) return Optional.empty();
        Pokemon parent1 = this.blockEntity.getTetheredPokemon().getFirst().getPokemon();
        Pokemon parent2 = this.blockEntity.getTetheredPokemon().getLast().getPokemon();

        return BreedingUtils.getOffspring(parent1, parent2);
    }

    public void produceEgg (PotentialPokemonProperties potentialEgg) {
        class_1657 owner = null;
        if (this.blockEntity.getOwnerId() != null && this.blockEntity.method_10997() != null) {
            owner = this.blockEntity.method_10997().method_18470(this.blockEntity.getOwnerId());
        }

        PokemonProperties properties = potentialEgg.createPokemonProperties();
        if (this.shinyBoosts > 0 && Boolean.FALSE.equals(properties.getShiny())) {
            --this.shinyBoosts;
            if (Math.random() < DaycarePlusOptions.getShinyBoosterRate()) properties.setShiny(true);
        }

        if (DaycarePlusOptions.doCompetitiveBreeding()) {
            FertilityProperty.decrement(potentialEgg.getPrimary());
            FertilityProperty.decrement(potentialEgg.getSecondary());

            if (DaycarePlusOptions.shouldConsumeHeldItems()) {
                if (potentialEgg.getPrimary().heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) && !potentialEgg.getPrimary().heldItem().method_31573(DPItemTags.NO_CONSUME_BREEDING)) {
                    potentialEgg.getPrimary().swapHeldItem(class_1799.field_8037, true);
                }
                if (potentialEgg.getSecondary().heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) && !potentialEgg.getSecondary().heldItem().method_31573(DPItemTags.NO_CONSUME_BREEDING)) {
                    potentialEgg.getSecondary().swapHeldItem(class_1799.field_8037, true);
                }
            }

            int eggFertility = DaycarePlusOptions.shouldEggsInheritFertility() ?
                    Math.min(FertilityProperty.get(potentialEgg.getPrimary()), FertilityProperty.get(potentialEgg.getSecondary())) :
                    FertilityProperty.getMax();

            properties.getCustomProperties().add(new IntSpeciesFeature(FertilityProperty.KEY, eggFertility));
        }

        if (owner instanceof class_3222 serverPlayer) {
            CobblemonEvents.COLLECT_EGG.emit(new CollectEggEvent(properties, potentialEgg.getPrimary(), potentialEgg.getSecondary(), serverPlayer));
        }
        DaycarePlusEvents.PRE_EGG_PRODUCED.invoker().beforeItemCreated(properties);

        class_1799 egg = DPItems.POKEMON_EGG.createEggItem(properties);
        DaycarePlusEvents.POST_EGG_PRODUCED.invoker().afterItemCreated(egg);

        ((PastureContainer)(Object)this.blockEntity).add(egg);
    }

    public void tick () {
        if (this.blockEntity.method_10997() instanceof class_3218 world) {
            if (world.method_8510() % 20 == 0) {
                world.method_14199(
                    class_2398.field_11201,
                    this.blockEntity.method_11016().method_10263() + 0.5,
                    this.blockEntity.method_11016().method_10264() + 1.5,
                    this.blockEntity.method_11016().method_10260() + 0.5,
                    1,
                    0, 0, 0,
                    0
                );
            }

            long ticksToProcess = Math.max(0, world.method_8510() - prevTime);
            this.prevTime = world.method_8510();
            long eggAttempts = ticksToProcess / DaycarePlusOptions.getTicksPerEggAttempt();

            if ((world.method_8510() + this.uuid.getLeastSignificantBits()) % DaycarePlusOptions.getTicksPerEggAttempt() == 0) ++eggAttempts;

            int calculatedEggs = 0;
            class_1657 owner = null;
            boolean applyMirrorHerb = false;
            if (this.blockEntity.getOwnerId() != null) {
                owner = this.blockEntity.method_10997().method_18470(this.blockEntity.getOwnerId());
            }

            for (int i = 0; i < eggAttempts; ++i) {
                if (world.method_8409().method_43058() > DaycarePlusOptions.getSuccessRatePerEggAttempt()) continue;
                applyMirrorHerb = true;

                int eggsToProduce = 1;
                if (this.twinBoosts > 0) {
                    eggsToProduce = 2;
                    --this.twinBoosts;
                }
                for (int j = 0; j < eggsToProduce; ++j) {
                    Optional<PotentialPokemonProperties> optionalEgg = this.predictEgg();
                    if (optionalEgg.isPresent()) {
                        if (owner != null) {
                            if (eggAttempts == 1) owner.method_43496(class_2561.method_43471("message.chat.daycareplus.egg_produced"));
                            else ++calculatedEggs;
                        }
                        this.produceEgg(optionalEgg.get());
                    }
                }
            }

            if (applyMirrorHerb && !this.blockEntity.getTetheredPokemon().isEmpty()) {
                Pokemon parent1 = this.blockEntity.getTetheredPokemon().getFirst().getPokemon();
                Pokemon parent2 = this.blockEntity.getTetheredPokemon().getLast().getPokemon();

                if (parent1 != null && parent2 != null) {
                    this.tryApplyMirrorHerb(parent1, parent2);
                    this.tryApplyMirrorHerb(parent2, parent1);
                }
            }

            calculatedEggs = class_3532.method_15340(calculatedEggs, 0, DaycarePlusOptions.getPastureInventorySize());
            if (calculatedEggs > 0 && owner != null) {
                if (calculatedEggs == 1) owner.method_43496(class_2561.method_43469("message.chat.daycareplus.single_egg_produced", calculatedEggs));
                else owner.method_43496(class_2561.method_43469("message.chat.daycareplus.multiple_egg_produced", calculatedEggs));
            }
        }
    }
}
