package com.provismet.cobblemon.daycareplus.cmixin;

import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.config.ClientOptions;
import com.provismet.cobblemon.daycareplus.gui.EggGroupWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(PCGUI.class)
public abstract class PCGUIMixin extends class_437 {
    protected PCGUIMixin (class_2561 title) {
        super(title);
    }

    @Shadow
    private Pokemon previewPokemon;

    @Unique
    private final EggGroupWidget eggGroupWidget = new EggGroupWidget(0, 0);

    @Inject(method = "init", at = @At("TAIL"))
    private void addEggWidget (CallbackInfo info) {
        this.method_37063(this.eggGroupWidget);
    }

    @Inject(method = "render", at = @At("TAIL"))
    private void renderEggGroups (class_332 context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (!ClientOptions.shouldShowEggGroupsInPC() || this.previewPokemon == null) return;

        this.eggGroupWidget.method_46421((super.field_22789 - PCGUI.BASE_WIDTH) / 2 - EggGroupWidget.WIDTH + 2);
        this.eggGroupWidget.method_46419(super.field_22790 / 2 + ClientOptions.getPcEggGroupPanelYOffset());
        this.eggGroupWidget.setPokemon(this.previewPokemon);
    }
}
