package com.provismet.cobblemon.daycareplus.cmixin;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.stats.StatWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.util.ClientEggGroup;
import com.provismet.cobblemon.daycareplus.util.DPResources;
import com.provismet.cobblemon.daycareplus.config.ClientOptions;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_8012;

@Mixin(StatWidget.class)
public abstract class StatWidgetMixin extends SoundlessWidget {
    public StatWidgetMixin (int pX, int pY, int pWidth, int pHeight, @NotNull class_2561 component) {
        super(pX, pY, pWidth, pHeight, component);
    }

    @Shadow @Final
    private Pokemon pokemon;

    @Inject(
        method = "renderWidget",
        at = @At(
            value = "INVOKE",
            target = "Lcom/cobblemon/mod/common/client/gui/summary/widgets/screens/stats/StatWidget;drawFriendship(IILnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/gui/DrawContext;I)V",
            shift = At.Shift.AFTER
        )
    )
    private void drawEggGroups (class_332 context, int pMouseX, int pMouseY, float pPartialTicks, CallbackInfo info, @Local(name = "drawY") LocalIntRef drawY, @Local(name = "matrices") class_4587 matrices) {
        if (!ClientOptions.shouldShowEggGroupsFeature()) return;

        int moduleX = this.method_46426() + 5;
        int moduleY = drawY.get() + 30;

        GuiUtilsKt.blitk(
            matrices,
            DPResources.EGG_GROUP_STAT_BACKGROUND,
            moduleX,
            moduleY,
            28,
            124
        );

        RenderHelperKt.drawScaledText(
            context,
            CobblemonResources.INSTANCE.getDEFAULT_LARGE(),
            class_2561.method_43471("daycareplus.ui.egg_group").method_27694(style -> style.method_10982(true)),
            moduleX + 62,
            moduleY + 2.5f,
            1f,
            1f,
            Integer.MAX_VALUE,
            class_8012.field_42973,
            true,
            true,
            pMouseX,
            pMouseY
        );

        class_5250 eggGroups;
        if (BreedableProperty.get(this.pokemon)) {
            eggGroups = ClientEggGroup.getGroups(this.pokemon)
                .stream()
                .map(group -> class_2561.method_43471("daycareplus.group." + group.name().toLowerCase(Locale.ROOT)))
                .reduce(class_2561.method_43473(), (existingText, groupName) -> {
                    if (existingText.getString().isEmpty()) return groupName;
                    return existingText.method_27693(" - ").method_10852(groupName);
                });
        }
        else {
            eggGroups = class_2561.method_43471("property.daycareplus.unbreedable");
        }

        RenderHelperKt.drawScaledText(
            context,
            CobblemonResources.INSTANCE.getDEFAULT_LARGE(),
            eggGroups,
            moduleX + 62,
            moduleY + 16,
            1f,
            1f,
            Integer.MAX_VALUE,
            class_8012.field_42973,
            true,
            true,
            pMouseX,
            pMouseY
        );

        drawY.set(drawY.get() + 30);
    }
}
