package com.provismet.cobblemon.daycareplus.cmixin;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.client.gui.summary.Summary;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.config.ClientOptions;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.util.ClientEggGroup;
import com.provismet.cobblemon.daycareplus.util.DPResources;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Mixin(Summary.class)
public abstract class SummaryMixin extends class_437 {
    @Unique
    private static final int LENGTH = 24;

    protected SummaryMixin (class_2561 title) {
        super(title);
    }

    @Shadow
    public Pokemon selectedPokemon;

    @Shadow @Final
    private static float SCALE;

    @Inject(method = "render", at = @At("TAIL"))
    private void renderEggIcon (class_332 context, int mouseX, int mouseY, float delta, CallbackInfo info) {
        if (!ClientOptions.shouldShowEggGroupsTooltip()) return;

        int x = super.field_22789 - 285;
        int y = super.field_22790 + 36;

        GuiUtilsKt.blitk(
            context.method_51448(),
            DPResources.SUMMARY_EGG_ICON,
            x, y,
            LENGTH, LENGTH,
            0, 0,
            LENGTH, LENGTH,
            0,
            1, 1, 1,
            1,
            true,
            SCALE
        );

        if (mouseX / SCALE >= x && mouseX / SCALE <= x + LENGTH && mouseY / SCALE >= y && mouseY / SCALE <= y + LENGTH) {
            List<class_2561> tooltip = new ArrayList<>();
            tooltip.add(class_2561.method_43471("daycareplus.ui.egg_group").method_27694(style -> style.method_10982(true)));
            if (BreedableProperty.get(this.selectedPokemon)) {
                for (EggGroup group : ClientEggGroup.getGroups(this.selectedPokemon)) {
                    tooltip.add(class_2561.method_43471("daycareplus.group." + group.name().toLowerCase(Locale.ROOT)).method_27694(style -> style.method_10982(false)));
                }
            }
            else {
                tooltip.add(class_2561.method_43471("property.daycareplus.unbreedable"));
            }
            context.method_51434(class_310.method_1551().field_1772, tooltip, mouseX, mouseY);
        }
    }
}
