package com.provismet.cobblemon.daycareplus.command;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.provismet.cobblemon.daycareplus.api.DaycarePlusEvents;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class GiveEggCommand {
    public static void register () {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> commandDispatcher.register(
            class_2170.method_9247("daycareplus")
                .then(class_2170.method_9247("give")
                    .requires(serverCommandSource -> serverCommandSource.method_9259(2))
                    .then(class_2170.method_9244("player", class_2186.method_9305())
                        .then(class_2170.method_9244("properties", PokemonPropertiesArgumentType.Companion.properties())
                            .executes(context -> {
                                class_3222 player = class_2186.method_9315(context, "player");
                                PokemonProperties properties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, "properties");
                                class_1799 egg = DPItems.POKEMON_EGG.createEggItem(properties);
                                DaycarePlusEvents.POST_EGG_PRODUCED.invoker().afterItemCreated(egg); // Skip the pre event for the command. Don't let the property get edited.
                                player.method_7270(egg);
                                context.getSource().method_9226(() -> class_2561.method_30163("Gave 1 Pokemon Egg to " + player.method_5477().getString()), false);
                                return 1;
                            })
                        )
                    )
                )
        ));
    }
}
