package com.provismet.cobblemon.daycareplus.datagen;

import com.provismet.cobblemon.daycareplus.registries.DPItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2447;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class RecipeGenerator extends FabricRecipeProvider {
    public RecipeGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    public void method_10419 (class_8790 recipeExporter) {
        class_2447.method_10437(class_7800.field_40642, DPItems.COPPER_INCUBATOR)
            .method_10439("iii")
            .method_10439("grg")
            .method_10439("iii")
            .method_10434('g', class_1802.field_8280)
            .method_10434('r', class_1802.field_8183)
            .method_10434('i', class_1802.field_27071)
            .method_10429(FabricRecipeProvider.method_32807(DPItems.POKEMON_EGG), FabricRecipeProvider.method_10426(DPItems.POKEMON_EGG))
            .method_10431(recipeExporter); // Unlock the recipe after collecting an egg.

        this.incubator(DPItems.IRON_INCUBATOR, class_1802.field_8773, DPItems.COPPER_INCUBATOR).method_10431(recipeExporter);
        this.incubator(DPItems.GOLD_INCUBATOR, class_1802.field_8494, DPItems.IRON_INCUBATOR).method_10431(recipeExporter); // Non-linear progression.
        this.incubator(DPItems.DIAMOND_INCUBATOR, class_1802.field_8603, DPItems.IRON_INCUBATOR).method_10431(recipeExporter);
        this.incubator(DPItems.NETHERITE_INCUBATOR, class_1802.field_22020, DPItems.DIAMOND_INCUBATOR).method_10431(recipeExporter); // Do not use upgrades, they carry over components!
    }

    private class_2447 incubator (class_1792 bag, class_1792 inputMaterial, class_1792 previousIncubator) {
        return class_2447.method_10437(class_7800.field_40642, bag)
            .method_10439("iii")
            .method_10439("grg")
            .method_10439("iii")
            .method_10434('g', class_1802.field_8280)
            .method_10434('r', previousIncubator)
            .method_10434('i', inputMaterial)
            .method_10429(FabricRecipeProvider.method_32807(previousIncubator), FabricRecipeProvider.method_10426(previousIncubator));
    }
}
