package com.provismet.cobblemon.daycareplus.gui;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.cobblemon.daycareplus.config.ClientOptions;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.util.ClientEggGroup;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_8012;

public class EggGroupWidget extends class_339 {
    public static final int WIDTH = 55;
    public static final int HEIGHT = 30;

    public static final class_2960 TEXTURE = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel.png");
    public static final class_2960 TEXTURE_HOVERED = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel_hovered.png");
    public static final class_2960 TEXTURE_COLLAPSED = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel_collapsed.png");
    public static final class_2960 TEXTURE_COLLAPSED_HOVERED = DaycarePlusMain.identifier("textures/gui/pc/egg_group_panel_collapsed_hovered.png");

    private static boolean collapsed = false;

    private Set<EggGroup> eggGroups = Set.of();
    private boolean breedable = true;

    public EggGroupWidget (int x, int y) {
        super(x, y, WIDTH, HEIGHT, class_2561.method_43471("daycareplus.ui.egg_group"));
    }

    @Override
    protected void method_48579 (class_332 context, int mouseX, int mouseY, float delta) {
        if ((this.eggGroups.isEmpty() && this.breedable) || !ClientOptions.shouldShowEggGroupsInPC()) return;

        class_2960 texture;
        if (this.method_49606()) texture = collapsed ? TEXTURE_COLLAPSED_HOVERED : TEXTURE_HOVERED;
        else texture = collapsed ? TEXTURE_COLLAPSED : TEXTURE;

        // Render background
        GuiUtilsKt.blitk(
            context.method_51448(),
            texture,
            this.method_46426(), this.method_46427(),
            HEIGHT, WIDTH
        );

        if (collapsed) return;

        // Render title
        RenderHelperKt.drawScaledText(
            context,
            CobblemonResources.INSTANCE.getDEFAULT_LARGE(),
            class_2561.method_43471("daycareplus.ui.egg_group").method_27694(style -> style.method_10982(true)),
            this.method_46426() + 34, this.method_46427() + 2,
            0.8f,
            1f,
            Integer.MAX_VALUE,
            class_8012.field_42973,
            true,
            true,
            mouseX, mouseY
        );

        // Render egg groups
        if (!this.breedable) {
            RenderHelperKt.drawScaledText(
                context,
                CobblemonResources.INSTANCE.getDEFAULT_LARGE(),
                class_2561.method_43471("property.daycareplus.unbreedable"),
                this.method_46426() + 34, this.method_46427() + 15,
                0.8f,
                1f,
                Integer.MAX_VALUE,
                class_8012.field_42973,
                true,
                true,
                mouseX, mouseY
            );
        }
        else if (this.eggGroups.size() == 1) {
            String eggGroup = this.eggGroups
                .stream()
                .reduce(EggGroup.UNDISCOVERED, (group1, group2) -> group2).name().toLowerCase(Locale.ROOT);

            RenderHelperKt.drawScaledText(
                context,
                CobblemonResources.INSTANCE.getDEFAULT_LARGE(),
                class_2561.method_43471("daycareplus.group." + eggGroup),
                this.method_46426() + 34, this.method_46427() + 15,
                0.8f,
                1f,
                Integer.MAX_VALUE,
                class_8012.field_42973,
                true,
                true,
                mouseX, mouseY
            );
        }
        else {
            int offset = 11;
            for (EggGroup group : this.eggGroups) {
                RenderHelperKt.drawScaledText(
                    context,
                    CobblemonResources.INSTANCE.getDEFAULT_LARGE(),
                    class_2561.method_43471("daycareplus.group." + group.name().toLowerCase(Locale.ROOT)),
                    this.method_46426() + 34, this.method_46427() + offset,
                    0.8f,
                    1f,
                    Integer.MAX_VALUE,
                    class_8012.field_42973,
                    true,
                    true,
                    mouseX, mouseY
                );
                offset += 8;
            }
        }
    }

    @Override
    protected void method_47399 (class_6382 builder) {

    }

    @Override
    public void method_25348 (double mouseX, double mouseY) {
        collapsed = !collapsed;
    }

    public void setPokemon (Pokemon pokemon) {
        this.eggGroups = ClientEggGroup.getGroups(pokemon);
        this.breedable = BreedableProperty.get(pokemon);
    }

    @Override
    public void method_25354 (class_1144 soundManager) {
        soundManager.method_4873(class_1109.method_4758(CobblemonSounds.PC_CLICK, 1f));
    }

    @Override
    public boolean method_37303 () {
        return false;
    }

    @Override
    public boolean method_49606 () {
        return super.method_49606() && ClientOptions.shouldShowEggGroupsInPC();
    }
}
