package com.provismet.cobblemon.daycareplus.item;

import com.cobblemon.mod.common.block.PastureBlock;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public abstract class AbstractDaycareModifierItem extends PolymerItem {
    public AbstractDaycareModifierItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        super(settings, baseVanillaItem, modelData);
    }

    @Override
    public class_1269 method_7884 (class_1838 context) {
        class_2248 block = context.method_8045().method_8320(context.method_8037()).method_26204();

        if (block instanceof PastureBlock pastureBlock) {
            class_2338 pasturePos = pastureBlock.getBasePosition(context.method_8045().method_8320(context.method_8037()), context.method_8037());
            class_2586 entity = context.method_8045().method_8321(pasturePos);

            if (entity instanceof PokemonPastureBlockEntity pasture && entity instanceof IMixinPastureBlockEntity daycare && daycare.shouldBreed()) {
                return this.applyToDaycare(context, pasture, daycare);
            }
            if (context.method_8036() != null) {
                context.method_8036().method_43496(class_2561.method_43471("message.chat.daycareplus.not_daycare"));
                return class_1269.field_5814;
            }
        }
        return super.method_7884(context);
    }

    protected abstract class_1269 applyToDaycare (class_1838 context, PokemonPastureBlockEntity pasture, IMixinPastureBlockEntity daycare);
}
