package com.provismet.cobblemon.daycareplus.registries;

import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.cobblemon.daycareplus.item.DaycareBoosterItem;
import com.provismet.cobblemon.daycareplus.item.DaycareSparkItem;
import com.provismet.cobblemon.daycareplus.item.IncubatorItem;
import com.provismet.cobblemon.daycareplus.item.FertilityBoosterItem;
import com.provismet.cobblemon.daycareplus.item.PokemonEggItem;
import com.provismet.cobblemon.daycareplus.item.PolymerItem;
import com.provismet.cobblemon.daycareplus.item.ShinyBoosterItem;
import com.provismet.cobblemon.daycareplus.item.component.IncubatorType;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public abstract class DPItems {
    public static final PokemonEggItem POKEMON_EGG = register("pokemon_egg",
        (settings, vanillaItem, modelData) ->
            new PokemonEggItem(settings.method_7889(1).method_7895(100), vanillaItem, modelData, PolymerResourcePackUtils.requestModel(vanillaItem, DaycarePlusMain.identifier("pokemon_egg_shiny").method_45138("item/")))
    );
    public static final FertilityBoosterItem FERTILITY_CANDY = register("fertility_candy", FertilityBoosterItem::new);
    public static final DaycareSparkItem DAYCARE_SPARK = register("daycare_spark", DaycareSparkItem::new);
    public static final DaycareBoosterItem DAYCARE_BOOSTER = register("daycare_booster", (settings, vanillaItem, modelData) -> new DaycareBoosterItem(settings.method_57349(DPItemDataComponents.BOOST_AMOUNT, 5), vanillaItem, modelData));
    public static final ShinyBoosterItem SHINY_BOOSTER = register("shiny_booster", (settings, vanillaItem, modelData) -> new ShinyBoosterItem(settings.method_57349(DPItemDataComponents.BOOST_AMOUNT, 5), vanillaItem, modelData));

    public static final IncubatorItem COPPER_INCUBATOR = registerIncubator("copper_incubator", IncubatorType.ofMain("copper"));
    public static final IncubatorItem IRON_INCUBATOR = registerIncubator("iron_incubator", IncubatorType.ofMain("iron"));
    public static final IncubatorItem GOLD_INCUBATOR = registerIncubator("gold_incubator", new IncubatorType("gold", "gold"));
    public static final IncubatorItem DIAMOND_INCUBATOR = registerIncubator("diamond_incubator", IncubatorType.ofMain("diamond"));
    public static final IncubatorItem NETHERITE_INCUBATOR = registerIncubator("netherite_incubator", IncubatorType.ofMain("netherite"), class_1792.class_1793::method_24359);

    private static <T extends PolymerItem> T register (String name, ItemConstructor<T> constructor) {
        class_2960 itemId = DaycarePlusMain.identifier(name);
        PolymerModelData model = PolymerResourcePackUtils.requestModel(class_1802.field_8675, itemId.method_45138("item/"));
        return class_2378.method_10230(class_7923.field_41178, itemId, constructor.apply(new class_1792.class_1793(), class_1802.field_8675, model));
    }

    private static IncubatorItem registerIncubator (String name, IncubatorType incubatorType, Function<class_1792.class_1793, class_1792.class_1793> settingsModifier) {
        PolymerModelData eggModel = PolymerResourcePackUtils.requestModel(class_1802.field_8675, DaycarePlusMain.identifier(name).method_45138("item/").method_48331("_full"));
        return register(name, (settings, vanillaItem, modelData) -> new IncubatorItem(
            settingsModifier.apply(settings)
                .method_7889(1)
                .method_57349(DPItemDataComponents.INCUBATOR_TYPE, incubatorType),
            vanillaItem,
            modelData,
            eggModel
        ));
    }

    private static IncubatorItem registerIncubator (String name, IncubatorType incubatorType) {
        return registerIncubator(name, incubatorType, settings -> settings);
    }

    public static void init () {
        DPIconItems.init();
    }

    @FunctionalInterface
    public interface ItemConstructor<T extends PolymerItem> {
        T apply (class_1792.class_1793 settings, class_1792 vanillaItem, PolymerModelData modelData);
    }
}
