package com.provismet.cobblemon.daycareplus;

import com.provismet.cobblemon.daycareplus.api.DaycarePlusInitializer;
import com.provismet.cobblemon.daycareplus.breeding.BreedingUtils;
import com.provismet.cobblemon.daycareplus.command.DPCommands;
import com.provismet.cobblemon.daycareplus.config.IncubatorTiers;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.handler.CobblemonEventHandler;
import com.provismet.cobblemon.daycareplus.networking.callback.PacketCallbacksC2S;
import com.provismet.cobblemon.daycareplus.registries.DPItemDataComponents;
import com.provismet.cobblemon.daycareplus.registries.DPItemGroups;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.registries.DPPayloads;
import com.provismet.cobblemon.daycareplus.registries.DPStats;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CompletableFuture;

public class DaycarePlusMain implements ModInitializer {
	public static final String MODID = "daycareplus";
	public static final Logger LOGGER = LoggerFactory.getLogger("Daycare+");

	public static class_2960 identifier (String path) {
		return class_2960.method_60655(MODID, path);
	}

	@Override
	public void onInitialize () {
		DaycarePlusOptions.load();
		IncubatorTiers.load();

		PolymerResourcePackUtils.markAsRequired();
		PolymerResourcePackUtils.addModAssets(MODID);

		DPItems.init();
		DPItemDataComponents.init();
		DPItemGroups.register();
		DPStats.init();
		DPCommands.register();
        DPPayloads.register();
        PacketCallbacksC2S.register();

		CobblemonEventHandler.register();
		ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new BreedingUtils());

		// Load when player joins.
		ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
			CompletableFuture.runAsync(() -> IncubatorCollection.loadFromJson(serverPlayNetworkHandler.method_32311()));
		});

		// Clean up incubators when a player logs out.
		ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, minecraftServer) -> {
			String playerUUID = serverPlayNetworkHandler.method_32311().method_5845();
			CompletableFuture.runAsync(() -> IncubatorCollection.remove(minecraftServer, playerUUID));
		});

		// Save when the server saves.
		ServerLifecycleEvents.BEFORE_SAVE.register((minecraftServer, flush, force) -> {
			CompletableFuture.runAsync(() -> IncubatorCollection.saveAll(minecraftServer));
		});

		FabricLoader.getInstance().getEntrypointContainers("daycareplus", DaycarePlusInitializer.class).forEach(
			initializer -> {
				try {
					initializer.getEntrypoint().onInitialize();
				}
				catch (Throwable e) {
					DaycarePlusMain.LOGGER.error("Daycare+ failed to initialise sidemod entrypoint from {} due to errors provided by it:", initializer.getProvider().getMetadata().getName(), e);
				}
			}
		);
	}
}