package com.provismet.cobblemon.daycareplus.api;

import java.util.Optional;
import net.minecraft.class_1799;

@SuppressWarnings("unused")
public class EggHelper {
    /**
     * @param stack A potential egg item.
     * @return Whether or not this item represents a Pokémon Egg.
     */
    public static boolean isEgg (class_1799 stack) {
        return tryGetEgg(stack).isPresent();
    }

    /**
     * A conversion method that can be used to convert eggs from other mods into Daycare+ eggs.
     * <p>
     * Use mixins to inject into this method to add compatibility.
     *
     * @param stack A stack that may or may not contain a pokemon egg.
     * @return A possible pokemon egg. If present, the stack will always be daycareplus:pokemon_egg.
     */
    public static Optional<PokemonEgg> tryGetEgg (class_1799 stack) {
        if (stack.method_7909() instanceof PokemonEggProviderItem eggProvider) return eggProvider.getEgg(stack);
        return Optional.empty();
    }
}
