package com.provismet.cobblemon.daycareplus.datagen;

import com.cobblemon.mod.common.CobblemonItems;
import com.provismet.cobblemon.daycareplus.registries.DPIconItems;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.util.tag.DPItemTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.concurrent.CompletableFuture;

public class ItemTagGenerator extends FabricTagProvider.ItemTagProvider {
    public ItemTagGenerator (FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, completableFuture, null);
    }

    @Override
    protected void method_10514 (class_7225.class_7874 wrapperLookup) {
        this.method_10512(DPItemTags.BREEDING_ITEM)
            .add(CobblemonItems.EVERSTONE)
            .add(CobblemonItems.POWER_ANKLET)
            .add(CobblemonItems.POWER_BAND)
            .add(CobblemonItems.POWER_BELT)
            .add(CobblemonItems.POWER_BRACER)
            .add(CobblemonItems.POWER_LENS)
            .add(CobblemonItems.POWER_WEIGHT)
            .add(CobblemonItems.MIRROR_HERB);

        this.method_10512(DPItemTags.COMPETITIVE_BREEDING)
            .addOptionalTag(DPItemTags.BREEDING_ITEM);

        this.method_10512(DPItemTags.NONCOMPETITIVE_BREEDING)
            .addOptionalTag(DPItemTags.BREEDING_ITEM)
            .add(CobblemonItems.DESTINY_KNOT);

        this.method_10512(DPItemTags.NO_CONSUME_BREEDING)
            .add(CobblemonItems.MIRROR_HERB);

        this.method_10512(DPItemTags.INCUBATORS)
            .add(DPItems.COPPER_INCUBATOR)
            .add(DPItems.IRON_INCUBATOR)
            .add(DPItems.GOLD_INCUBATOR)
            .add(DPItems.DIAMOND_INCUBATOR)
            .add(DPItems.NETHERITE_INCUBATOR);

        this.method_10512(DPItemTags.BYPASS_DAYCARE_OPEN)
            .addOptionalTag(DPItemTags.INCUBATORS)
            .add(DPItems.DAYCARE_SPARK)
            .add(DPItems.DAYCARE_BOOSTER);

        this.method_10512(DPItemTags.GUI)
            .add(DPIconItems.INFO)
            .add(DPIconItems.LEFT)
            .add(DPIconItems.RIGHT)
            .add(DPIconItems.TAKE_ALL);

        this.method_10512(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "hidden_from_recipe_viewers")))
            .addOptionalTag(DPItemTags.GUI);
    }
}
