package com.provismet.cobblemon.daycareplus.gui;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.common.collect.ImmutableList;
import com.provismet.cobblemon.daycareplus.breeding.BreedingUtils;
import com.provismet.cobblemon.daycareplus.feature.BreedableProperty;
import com.provismet.cobblemon.daycareplus.feature.FertilityProperty;
import com.provismet.cobblemon.daycareplus.breeding.PotentialPokemonProperties;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.registries.DPIconItems;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.util.Styles;
import com.provismet.cobblemon.daycareplus.util.tag.DPItemTags;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;

public interface DaycareGUI {
    static SimpleGui create (PokemonPastureBlockEntity pastureBlockEntity, IMixinPastureBlockEntity mixinPasture, class_3222 player, class_2680 state, class_3965 hit) {
        GuiElement filler = GuiElementBuilder.from(class_1802.field_8871.method_7854())
            .hideDefaultTooltip()
            .hideTooltip()
            .build();

        GuiElement fillerHeldItem = GuiElementBuilder.from(class_1802.field_8736.method_7854())
            .hideDefaultTooltip()
            .setName(class_2561.method_43471("gui.button.daycareplus.no_item").method_27694(Styles.WHITE_NO_ITALICS))
            .build();

        GuiElement infoButton = GuiElementBuilder.from(DPIconItems.INFO.method_7854())
            .setName(class_2561.method_43471("gui.button.daycareplus.info").method_27694(Styles.WHITE_NO_ITALICS))
            .addLoreLine(class_2561.method_43471("gui.button.daycareplus.info.tooltip.1").method_27694(Styles.GRAY_NO_ITALICS))
            .addLoreLine(class_2561.method_43471("gui.button.daycareplus.info.tooltip.2").method_27694(Styles.GRAY_NO_ITALICS))
            .build();

        GuiElement openPasture = GuiElementBuilder.from(CobblemonItems.PASTURE.method_7854())
            .setName(class_2561.method_43471("gui.button.daycareplus.open_pasture").method_27694(Styles.WHITE_NO_ITALICS))
            .setCallback((index, type, action, gui) -> {
                gui.getPlayer().method_7346();
                mixinPasture.setShouldSkipDaycareGUI(true);
                state.method_55781(gui.getPlayer().method_37908(), gui.getPlayer(), hit);
            })
            .build();

        GuiElement eggCounter = mixinPasture.getEggCounterButton();
        GuiElement boostCounter = mixinPasture.getBoostCounterButton();

        Pokemon parent1 = null;
        Pokemon parent2 = null;
        if (!pastureBlockEntity.getTetheredPokemon().isEmpty()) parent1 = pastureBlockEntity.getTetheredPokemon().getFirst().getPokemon();
        if (pastureBlockEntity.getTetheredPokemon().size() == 2) parent2 = pastureBlockEntity.getTetheredPokemon().getLast().getPokemon();

        GuiElement missingParent = GuiElementBuilder.from(class_1802.field_8077.method_7854())
            .setName(class_2561.method_43471("gui.button.daycareplus.no_parent").method_27694(Styles.WHITE_NO_ITALICS))
            .addLoreLine(class_2561.method_43471("gui.button.daycareplus.no_parent.tooltip").method_27694(Styles.GRAY_NO_ITALICS))
            .build();

        GuiElement parent1Info;
        GuiElement parent1Item = fillerHeldItem;
        if (parent1 != null) {
            parent1Info = createButtonForPokemon(parent1);

            if (DaycarePlusOptions.doCompetitiveBreeding() ? parent1.heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) : parent1.heldItem().method_31573(DPItemTags.NONCOMPETITIVE_BREEDING)) {
                parent1Item = GuiElementBuilder.from(parent1.heldItem())
                    .hideDefaultTooltip()
                    .addLoreLine(class_2561.method_43471(parent1.heldItem().method_7922() + ".breeding").method_27694(Styles.GRAY_NO_ITALICS))
                    .build();
            }
        }
        else {
            parent1Info = missingParent;
        }

        GuiElement parent2Info;
        GuiElement parent2Item = fillerHeldItem;
        if (parent2 != null) {
            parent2Info = createButtonForPokemon(parent2);

            if (DaycarePlusOptions.doCompetitiveBreeding() ? parent2.heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) : parent2.heldItem().method_31573(DPItemTags.NONCOMPETITIVE_BREEDING)) {
                parent2Item = GuiElementBuilder.from(parent2.heldItem())
                    .hideDefaultTooltip()
                    .addLoreLine(class_2561.method_43471(parent2.heldItem().method_7922() + ".breeding").method_27694(Styles.GRAY_NO_ITALICS))
                    .build();
            }
        }
        else {
            parent2Info = missingParent;
        }

        GuiElement offspringInfo;
        Optional<PotentialPokemonProperties> offspring = BreedingUtils.getOffspring(parent1, parent2);
        if (offspring.isPresent()) {
            Map<Stat, PotentialPokemonProperties.PotentialIV> ivs = offspring.get().getPossibleIVs();
            PokemonProperties props = offspring.get().createPokemonProperties();
            props.setShiny(false);
            Pokemon tile = props.create();

            ImmutableList.Builder<class_2561> eggData = ImmutableList.builder();
            eggData.add(
                class_2561.method_43471("property.daycareplus.species").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852(tile.getSpecies().getTranslatedName().method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.form").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852(class_2561.method_43470(tile.getForm().getName()).method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.ability").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852(listOfTranslatable(class_2561.method_43470(", ").method_27694(Styles.WHITE_NO_ITALICS), Styles.WHITE_NO_ITALICS, offspring.get().getPossibleAbilities().stream().map(AbilityTemplate::getDisplayName).toArray(String[]::new))),
                class_2561.method_43471("property.daycareplus.nature").method_27694(Styles.formattedNoItalics(class_124.field_1054)).method_10852((offspring.get().getPossibleNatures().isEmpty() ? class_2561.method_43470("?").method_27694(Styles.WHITE_NO_ITALICS) : listOfTranslatable(class_2561.method_43470(",").method_27694(Styles.WHITE_NO_ITALICS), Styles.WHITE_NO_ITALICS, offspring.get().getPossibleNatures().stream().map(Nature::getDisplayName).toArray(String[]::new))))
            );
            if (props.getMoves() != null && !props.getMoves().isEmpty()) {
                eggData.add(class_2561.method_43471("property.daycareplus.moves").method_27694(Styles.formattedNoItalics(class_124.field_1054))
                    .method_10852(listOfTranslatable(class_2561.method_43470(", ").method_27694(Styles.WHITE_NO_ITALICS), Styles.WHITE_NO_ITALICS, props.getMoves().stream().map(move -> "cobblemon.move." + move).toArray(String[]::new))));
            }
            eggData.add(
                class_2561.method_43473(),
                class_2561.method_43471("property.daycareplus.ivs").method_27694(Styles.WHITE_NO_ITALICS),
                class_2561.method_43471("property.daycareplus.hp").method_27694(Styles.colouredNoItalics(Styles.HP)).method_10852(class_2561.method_43470(ivs.get(Stats.HP).toString()).method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.attack").method_27694(Styles.colouredNoItalics(Styles.ATTACK)).method_10852(class_2561.method_43470(ivs.get(Stats.ATTACK).toString()).method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.defence").method_27694(Styles.colouredNoItalics(Styles.DEFENCE)).method_10852(class_2561.method_43470(ivs.get(Stats.DEFENCE).toString()).method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.special_attack").method_27694(Styles.colouredNoItalics(Styles.SPECIAL_ATTACK)).method_10852(class_2561.method_43470(ivs.get(Stats.SPECIAL_ATTACK).toString()).method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.special_defence").method_27694(Styles.colouredNoItalics(Styles.SPECIAL_DEFENCE)).method_10852(class_2561.method_43470(ivs.get(Stats.SPECIAL_DEFENCE).toString()).method_27694(Styles.WHITE_NO_ITALICS)),
                class_2561.method_43471("property.daycareplus.speed").method_27694(Styles.colouredNoItalics(Styles.SPEED)).method_10852(class_2561.method_43470(ivs.get(Stats.SPEED).toString()).method_27694(Styles.WHITE_NO_ITALICS))
            );

            if (DaycarePlusOptions.doCompetitiveBreeding()) {
                int newFertility = class_3532.method_15340(Math.min(FertilityProperty.get(parent1), FertilityProperty.get(parent2)) - 1, 0, FertilityProperty.getMax());
                eggData.add(
                    class_2561.method_43473(),
                    class_2561.method_43471("property.daycareplus.fertility").method_27694(Styles.formattedNoItalics(class_124.field_1077)).method_10852(class_2561.method_43470(String.valueOf(newFertility)).method_27694(Styles.WHITE_NO_ITALICS))
                );
            }

            if (DaycarePlusOptions.shouldShowShinyChance()) eggData.add(
                class_2561.method_43473(),
                class_2561.method_43471("property.daycareplus.shiny").method_27694(Styles.formattedNoItalics(class_124.field_1065)).method_10852(class_2561.method_43470("1/" + Math.max(1, (int)(1 / offspring.get().getShinyRate()))).method_27694(Styles.WHITE_NO_ITALICS))
            );

            if (FabricLoader.getInstance().isDevelopmentEnvironment()) eggData.add(
                class_2561.method_43473(),
                class_2561.method_43470("(Debug) Aspects: " + String.join(", ", tile.getAspects()))
            );

            offspringInfo = GuiElementBuilder.from(PokemonItem.from(props))
                .setName(class_2561.method_43471("gui.button.daycareplus.offspring").method_27694(Styles.WHITE_NO_ITALICS))
                .setLore(eggData.build())
                .build();
        }
        else {
            offspringInfo = GuiElementBuilder.from(class_1802.field_8077.method_7854())
                .setName(class_2561.method_43471("gui.button.daycareplus.offspring.empty").method_27694(style -> style.method_10978(false).method_10977(class_124.field_1068)))
                .addLoreLine(class_2561.method_43471("gui.button.daycareplus.offspring.empty.tooltip").method_27694(style -> style.method_10978(false).method_10977(class_124.field_1080)))
                .build();
        }

        SimpleGui gui = new SimpleGui(class_3917.field_18667, player, false) {
            @Override
            public void onOpen () {
                this.player.method_17356(CobblemonSounds.PC_ON, class_3419.field_15245, 1f, 1f);
            }

            @Override
            public void onClose () {
                this.player.method_17356(CobblemonSounds.PC_OFF, class_3419.field_15245, 1f, 1f);
            }
        };
        gui.setTitle(class_2561.method_43471("gui.title.daycareplus.daycare"));

        for (int i = 0; i < gui.getVirtualSize(); ++i) {
            gui.setSlot(i, filler);
        }

        if (mixinPasture.getExtension() != null && mixinPasture.getExtension().getBoosts() > 0) {
            gui.setSlot(5, boostCounter);
        }
        gui.setSlot(6, eggCounter);
        gui.setSlot(7, openPasture);
        gui.setSlot(8, infoButton);
        gui.setSlot(20, parent1Info);
        gui.setSlot(22, offspringInfo);
        gui.setSlot(24, parent2Info);
        gui.setSlot(29, parent1Item);
        gui.setSlot(33, parent2Item);
        return gui;
    }

    static GuiElement createEggButton (IMixinPastureBlockEntity mixinPasture) {
        return GuiElementBuilder.from(DPItems.POKEMON_EGG.method_7854())
            .hideDefaultTooltip()
            .setName(class_2561.method_43469("gui.button.daycareplus.eggs_held", mixinPasture.count(), mixinPasture.method_5439()).method_27694(Styles.WHITE_NO_ITALICS))
            .build();
    }

    static GuiElement createBoostButton (IMixinPastureBlockEntity mixinPasture) {
        return GuiElementBuilder.from(DPItems.DAYCARE_BOOSTER.method_7854())
            .hideDefaultTooltip()
            .setName(class_2561.method_43469("gui.button.daycareplus.boosts_remaining", mixinPasture.getExtension() != null ? mixinPasture.getExtension().getBoosts() : 0).method_27694(Styles.WHITE_NO_ITALICS))
            .build();
    }

    static GuiElement createButtonForPokemon (Pokemon pokemon) {
        GuiElementBuilder builder = GuiElementBuilder.from(PokemonItem.from(pokemon))
            .hideDefaultTooltip()
            .setName(class_2561.method_43471("gui.button.daycareplus.parent").method_27694(Styles.WHITE_NO_ITALICS))
            .addLoreLine(formatProperty("property.daycareplus.species", Styles.formattedNoItalics(class_124.field_1054), pokemon.getSpecies().getTranslatedName()))
            .addLoreLine(formatProperty("property.daycareplus.form", Styles.formattedNoItalics(class_124.field_1054), pokemon.getForm().getName()))
            .addLoreLine(formatProperty("property.daycareplus.ability", Styles.formattedNoItalics(class_124.field_1054), class_2561.method_43471(pokemon.getAbility().getDisplayName())))
            .addLoreLine(formatProperty("property.daycareplus.nature", Styles.formattedNoItalics(class_124.field_1054), class_2561.method_43471(pokemon.getNature().getDisplayName())))
            .addLoreLine(class_2561.method_43473())
            .addLoreLine(class_2561.method_43471("property.daycareplus.ivs").method_27694(Styles.WHITE_NO_ITALICS))
            .addLoreLine(formatProperty("property.daycareplus.hp", Styles.colouredNoItalics(Styles.HP), String.valueOf(pokemon.getIvs().getOrDefault(Stats.HP))))
            .addLoreLine(formatProperty("property.daycareplus.attack", Styles.colouredNoItalics(Styles.ATTACK), String.valueOf(pokemon.getIvs().getOrDefault(Stats.ATTACK))))
            .addLoreLine(formatProperty("property.daycareplus.defence", Styles.colouredNoItalics(Styles.DEFENCE), String.valueOf(pokemon.getIvs().getOrDefault(Stats.DEFENCE))))
            .addLoreLine(formatProperty("property.daycareplus.special_attack", Styles.colouredNoItalics(Styles.SPECIAL_ATTACK), String.valueOf(pokemon.getIvs().getOrDefault(Stats.SPECIAL_ATTACK))))
            .addLoreLine(formatProperty("property.daycareplus.special_defence", Styles.colouredNoItalics(Styles.SPECIAL_DEFENCE), String.valueOf(pokemon.getIvs().getOrDefault(Stats.SPECIAL_DEFENCE))))
            .addLoreLine(formatProperty("property.daycareplus.speed", Styles.colouredNoItalics(Styles.SPEED), String.valueOf(pokemon.getIvs().getOrDefault(Stats.SPEED))));


        if (!BreedableProperty.get(pokemon)) {
            builder.addLoreLine(class_2561.method_43473())
                .addLoreLine(class_2561.method_43471("property.daycareplus.unbreedable").method_27694(Styles.formattedNoItalics(class_124.field_1079)));
        }
        else if (DaycarePlusOptions.doCompetitiveBreeding()) {
            builder.addLoreLine(class_2561.method_43473())
                .addLoreLine(formatProperty("property.daycareplus.fertility", Styles.formattedNoItalics(class_124.field_1077), String.valueOf(FertilityProperty.get(pokemon))));
        }

        return builder.build();
    }

    private static class_2561 formatProperty (String translationKey, UnaryOperator<class_2583> style, String value) {
        return formatProperty(translationKey, style, class_2561.method_43470(value));
    }

    private static class_2561 formatProperty (String translationKey, UnaryOperator<class_2583> style, class_5250 value) {
        return class_2561.method_43471(translationKey).method_27694(style)
            .method_10852(value.method_27694(Styles.WHITE_NO_ITALICS));
    }

    private static class_2561 listOfTranslatable (class_2561 separator, UnaryOperator<class_2583> style, String... translatables) {
        class_5250 text = class_2561.method_43473();
        for (int i = 0; i < translatables.length; ++i) {
            text = text.method_10852(class_2561.method_43471(translatables[i]).method_27694(style));
            if (i < translatables.length - 1) text = text.method_10852(separator);
        }
        return text;
    }
}
