package com.provismet.cobblemon.daycareplus.gui;

import com.provismet.cobblemon.daycareplus.registries.DPIconItems;
import com.provismet.cobblemon.daycareplus.storage.EggStorage;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Optional;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public class EggStorageGUI extends SimpleGui {
    private static final int ITEMS_PER_ROW = 9;
    private static final int ROWS_PER_PAGE = 5;
    private static final int ITEMS_PER_PAGE = ITEMS_PER_ROW * ROWS_PER_PAGE;

    private final EggStorage storage;
    private int minSlotDisplayed;
    private boolean isAtEnd;

    protected EggStorageGUI (class_3222 player, EggStorage storage) {
        super(class_3917.field_17327, player, false);
        this.storage = storage;
    }

    public static EggStorageGUI create (class_3222 player, String storageName) {
        Optional<EggStorage> storage = IncubatorCollection.getOrCreate(player).get(storageName);
        if (storage.isPresent()) {
            EggStorageGUI gui = new EggStorageGUI(player, storage.get());
            gui.updateBorder();
            gui.loadPage();
            gui.setTitle(class_2561.method_43471("gui.title.daycareplus.incubator"));
            return gui;
        }

        return null;
    }

    private void updateBorder () {
        GuiElement borderFiller = GuiElementBuilder.from(class_1802.field_8157.method_7854())
            .hideDefaultTooltip()
            .hideTooltip()
            .build();

        for (int i = 0; i < ITEMS_PER_ROW; ++i) {
            this.setSlot(i, borderFiller);
        }

        GuiElement prev = GuiElementBuilder.from(DPIconItems.LEFT.method_7854())
            .setName(class_2561.method_43471("gui.button.daycareplus.prev").method_27694(Styles.WHITE_NO_ITALICS))
            .setCallback((index, clickType, action, gui) -> this.previousPage())
            .build();

        GuiElement next = GuiElementBuilder.from(DPIconItems.RIGHT.method_7854())
            .setName(class_2561.method_43471("gui.button.daycareplus.next").method_27694(Styles.WHITE_NO_ITALICS))
            .setCallback((index, clickType, action, gui) -> this.nextPage())
            .build();

        GuiElement take = GuiElementBuilder.from(DPIconItems.TAKE_ALL.method_7854())
            .setName(class_2561.method_43471("gui.button.daycareplus.take").method_27694(Styles.WHITE_NO_ITALICS))
            .setCallback((index, type1, action, gui) -> {
                this.player.method_31548().field_7547.forEach(this.storage::addCopyAndEmpty);
                this.player.method_17356(class_3417.field_34376, class_3419.field_15248, 1f, 1f);
                this.loadPage();
            })
            .build();

        this.setSlot(0, prev);
        this.setSlot(7, take);
        this.setSlot(8, next);
    }

    private void loadPage () {
        for (int i = 0; i + 9 < this.getVirtualSize(); ++i) {
            int storageIndex = this.minSlotDisplayed + i;
            GuiElement eggButton;

            if (storageIndex < this.storage.size()) {
                eggButton = GuiElementBuilder.from(this.storage.getItem(this.minSlotDisplayed + i))
                    .setCallback((index, clickType, action, gui) -> {
                        class_1799 stack = this.storage.getItem(storageIndex);
                        if (!stack.method_7960() && this.player.method_7270(stack)) {
                            this.storage.remove(storageIndex);
                            this.player.method_17356(class_3417.field_34377, class_3419.field_15248, 1f, 1f);
                            this.loadPage();
                        }
                    })
                    .build();
            }
            else {
                eggButton = GuiElementBuilder.from(class_1799.field_8037).build();
            }

            this.setSlot(i + 9, eggButton);
        }

        this.isAtEnd = this.minSlotDisplayed + ITEMS_PER_PAGE > this.storage.size();
    }

    private void nextPage () {
        if (!isAtEnd) {
            minSlotDisplayed += ITEMS_PER_PAGE;
            this.loadPage();
        }
    }

    private void previousPage () {
        if (this.minSlotDisplayed > 0) {
            this.minSlotDisplayed = Math.max(0, this.minSlotDisplayed - ITEMS_PER_PAGE);
            this.loadPage();
        }
    }

    @Override
    public boolean onAnyClick (int index, ClickType type, class_1713 action) {
        if (index >= 54) {
            int inventoryIndex;
            if (index >= 81) inventoryIndex = index - 81; // Hotbar
            else inventoryIndex = index - 45; // Main - Hotbar is first in the list (54 - 9).

            if (inventoryIndex < this.player.method_31548().field_7547.size()) {
                this.storage.addCopyAndEmpty(this.player.method_31548().field_7547.get(inventoryIndex));
            }
            this.loadPage();
        }

        return super.onAnyClick(index, type, action);
    }

    @Override
    public void onTick () {
        if (this.player.field_6012 % 20 == 1) { // Reload one tick after the eggs have ticked.
            this.loadPage();
        }
    }
}
