package com.provismet.cobblemon.daycareplus.gui;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.provismet.cobblemon.daycareplus.breeding.BreedingLink;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public interface IntroGUI {
    static SimpleGui create (IMixinPastureBlockEntity pastureMixin, class_3222 serverPlayer) {
        GuiElement filler = GuiElementBuilder.from(class_1802.field_8871.method_7854())
            .hideTooltip()
            .hideDefaultTooltip()
            .build();

        GuiElement activateBreeding = GuiElementBuilder.from(DPItems.POKEMON_EGG.method_7854())
            .hideDefaultTooltip()
            .setName(class_2561.method_43471("gui.button.daycareplus.intro.daycare").method_27694(Styles.WHITE_NO_ITALICS))
            .addLoreLine(class_2561.method_43471("gui.button.daycareplus.intro.daycare.tooltip.1").method_27694(Styles.GRAY_NO_ITALICS))
            .addLoreLine(class_2561.method_43469("gui.button.daycareplus.intro.daycare.tooltip.2", BreedingLink.count(serverPlayer), DaycarePlusOptions.getMaxPasturesPerPlayer()).method_27694(Styles.GRAY_NO_ITALICS))
            .setCallback((index, type, action, gui) -> {
                if (BreedingLink.isAtLimit(gui.getPlayer())) {
                    gui.getPlayer().method_17356(class_3417.field_15008, class_3419.field_15248, 1f, 1f);
                    gui.getPlayer().method_43496(class_2561.method_43471("message.overlay.daycareplus.limit_reached").method_27692(class_124.field_1061));
                } else {
                    if (pastureMixin.getBreederUUID() == null) {
                        pastureMixin.setBreederUUID(UUID.randomUUID());
                    }
                    BreedingLink.add(serverPlayer, pastureMixin.getBreederUUID());
                    pastureMixin.setShouldBreed(true);
                    gui.close();
                }
            })
            .build();

        GuiElement noBreeding = GuiElementBuilder.from(CobblemonItems.PASTURE.method_7854())
            .hideDefaultTooltip()
            .setName(class_2561.method_43471("gui.button.daycareplus.intro.pasture").method_27694(Styles.WHITE_NO_ITALICS))
            .addLoreLine(class_2561.method_43471("gui.button.daycareplus.intro.pasture.tooltip").method_27694(Styles.GRAY_NO_ITALICS))
            .setCallback((index, type, action, gui) -> {
                pastureMixin.setShouldBreed(false);
                pastureMixin.setSkipIntroDialogue(true);
                gui.close();
            })
            .build();

        SimpleGui gui = new SimpleGui(class_3917.field_17326, serverPlayer, false) {
            @Override
            public void onOpen () {
                this.player.method_17356(CobblemonSounds.PC_ON, class_3419.field_15245, 1f, 1f);
            }

            @Override
            public void onClose () {
                this.player.method_17356(CobblemonSounds.PC_OFF, class_3419.field_15245, 1f, 1f);
            }
        };
        gui.setTitle(class_2561.method_43471("gui.title.daycareplus.intro"));

        for (int i = 0; i < gui.getVirtualSize(); ++i) {
            gui.setSlot(i, filler);
        }
        gui.setSlot(11, activateBreeding);
        gui.setSlot(15, noBreeding);
        return gui;
    }
}
