package com.provismet.cobblemon.daycareplus.item;

import com.cobblemon.mod.common.block.PastureBlock;
import com.provismet.cobblemon.daycareplus.breeding.PotentialPokemonProperties;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class DaycareSparkItem extends PolymerItem {
    public DaycareSparkItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        super(settings, baseVanillaItem, modelData);
    }

    @Override
    public void method_7851 (class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add(class_2561.method_43471(this.method_7876() + ".tooltip").method_27694(Styles.GRAY_NO_ITALICS));
    }

    @Override
    public class_1269 method_7884 (class_1838 context) {
        class_2248 block = context.method_8045().method_8320(context.method_8037()).method_26204();

        if (block instanceof PastureBlock pastureBlock) {
            class_2338 pasturePos = pastureBlock.getBasePosition(context.method_8045().method_8320(context.method_8037()), context.method_8037());

            if (context.method_8045().method_8321(pasturePos) instanceof IMixinPastureBlockEntity daycare && daycare.shouldBreed()) {
                Optional<PotentialPokemonProperties> potentialEgg = daycare.getExtension().predictEgg();
                if (potentialEgg.isPresent()) {
                    daycare.getExtension().produceEgg(potentialEgg.get());

                    if (context.method_8036() != null) {
                        context.method_8036().method_43496(class_2561.method_43471("message.chat.daycareplus.egg_produced"));
                    }
                    context.method_8041().method_57008(1, context.method_8036());
                    return class_1269.field_5812;
                }
                else {
                    if (context.method_8036() != null) {
                        context.method_8036().method_7353(class_2561.method_43471("message.overlay.daycareplus.spark_failure").method_27692(class_124.field_1061), true);
                    }
                    return class_1269.field_5814;
                }
            }
            if (context.method_8036() != null) {
                context.method_8036().method_43496(class_2561.method_43471("message.chat.daycareplus.not_daycare"));
                return class_1269.field_5814;
            }
        }
        return super.method_7884(context);
    }
}
