package com.provismet.cobblemon.daycareplus.item;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.provismet.cobblemon.daycareplus.api.PokemonEgg;
import com.provismet.cobblemon.daycareplus.api.PokemonEggProviderItem;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.registries.DPItemDataComponents;
import com.provismet.cobblemon.daycareplus.util.StringFormatting;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9334;

public class PokemonEggItem extends PolymerItem implements PokemonEggProviderItem {
    private static final int TICKS_PER_MINUTE = 60 * 20;

    private final PolymerModelData shiny;

    public PokemonEggItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData, PolymerModelData shinyModel) {
        super(settings, baseVanillaItem, modelData);
        this.shiny = shinyModel;
    }

    public class_1799 createEggItem (PokemonProperties properties) {
        return new PokemonEgg(properties).getItem();
    }

    @Override
    public Optional<PokemonEgg> getEgg (class_1799 stack) {
        String properties = stack.method_57824(DPItemDataComponents.POKEMON_PROPERTIES);
        if (properties == null) return Optional.empty();

        PokemonEgg egg = new PokemonEgg(
            properties,
            this.getMaxSteps(stack),
            this.getRemainingSteps(stack),
            false
        );
        return Optional.of(egg);
    }

    @Override
    public void method_7851 (class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        if (stack.method_57826(class_9334.field_49638)) return;

        Integer steps = stack.method_57824(DPItemDataComponents.EGG_STEPS);
        if (steps != null) {
            String minutes = "" + (steps / TICKS_PER_MINUTE);
            String seconds = "" + ((steps % TICKS_PER_MINUTE) / 20);

            if (minutes.length() < 2) minutes = "0" + minutes;
            if (seconds.length() < 2) seconds = "0" + seconds;

            tooltip.add(class_2561.method_43469("tooltip.daycareplus.egg.ticks", minutes + ":" + seconds));
        }
        if (!DaycarePlusOptions.shouldShowEggTooltip()) return;

        tooltip.add(class_2561.method_43473());
        String properties = stack.method_57824(DPItemDataComponents.POKEMON_PROPERTIES);
        if (properties == null) {
            tooltip.add(class_2561.method_43471("tooltip.daycareplus.egg.no_data"));
        }
        else {
            PokemonProperties pokemonProperties = PokemonProperties.Companion.parse(properties);
            if (pokemonProperties.getSpecies() != null) {
                class_5250 species = class_2561.method_43471("property.daycareplus.species").method_27692(class_124.field_1054)
                    .method_10852(this.getTooltipSpeciesName(pokemonProperties));
                tooltip.add(species);
            }
            if (pokemonProperties.getForm() != null) tooltip.add(class_2561.method_43471("property.daycareplus.form").method_27692(class_124.field_1054).method_10852(this.getTooltipFormName(pokemonProperties)));
            if (pokemonProperties.getNature() != null) tooltip.add(class_2561.method_43471("property.daycareplus.nature").method_27692(class_124.field_1054).method_10852(this.getTooltipNatureName(pokemonProperties)));
            if (pokemonProperties.getAbility() != null) tooltip.add(class_2561.method_43471("property.daycareplus.ability").method_27692(class_124.field_1054).method_10852(this.getTooltipAbilityName(pokemonProperties)));
            if (pokemonProperties.getGender() != null && pokemonProperties.getGender() != Gender.GENDERLESS) {
                class_2561 gender = switch (pokemonProperties.getGender()) {
                    case MALE -> class_2561.method_43470("M").method_27692(class_124.field_1078);
                    case FEMALE -> class_2561.method_43470("F").method_27692(class_124.field_1061);
                    default -> class_2561.method_43470("");
                };

                tooltip.add(class_2561.method_43471("property.daycareplus.gender").method_27692(class_124.field_1054).method_10852(gender));
            }

            IVs iv = pokemonProperties.getIvs();
            if (iv != null) {
                tooltip.add(class_2561.method_43473());
                tooltip.add(class_2561.method_43471("property.daycareplus.hp").method_27694(Styles.colouredNoItalics(Styles.HP))
                    .method_10852(class_2561.method_43470(this.formatIV(iv, Stats.HP)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add(class_2561.method_43471("property.daycareplus.attack").method_27694(Styles.colouredNoItalics(Styles.ATTACK))
                    .method_10852(class_2561.method_43470(this.formatIV(iv, Stats.ATTACK)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add(class_2561.method_43471("property.daycareplus.defence").method_27694(Styles.colouredNoItalics(Styles.DEFENCE))
                    .method_10852(class_2561.method_43470(this.formatIV(iv, Stats.DEFENCE)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add(class_2561.method_43471("property.daycareplus.special_attack").method_27694(Styles.colouredNoItalics(Styles.SPECIAL_ATTACK))
                    .method_10852(class_2561.method_43470(this.formatIV(iv, Stats.SPECIAL_ATTACK)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add(class_2561.method_43471("property.daycareplus.special_defence").method_27694(Styles.colouredNoItalics(Styles.SPECIAL_DEFENCE))
                    .method_10852(class_2561.method_43470(this.formatIV(iv, Stats.SPECIAL_DEFENCE)).method_27694(Styles.WHITE_NO_ITALICS)));
                tooltip.add(class_2561.method_43471("property.daycareplus.speed").method_27694(Styles.colouredNoItalics(Styles.SPEED))
                    .method_10852(class_2561.method_43470(this.formatIV(iv, Stats.SPEED)).method_27694(Styles.WHITE_NO_ITALICS)));
            }
        }
    }

    // Exists for mixin convenience.
    private class_5250 getTooltipSpeciesName (PokemonProperties properties) {
        class_5250 text = class_2561.method_43470(StringFormatting.titleCase(properties.getSpecies())).method_27694(Styles.WHITE_NO_ITALICS);
        if (Objects.requireNonNullElse(properties.getShiny(), false)) text.method_10852(class_2561.method_43470(" ★").method_27692(class_124.field_1065));
        return text;
    }

    // Exists for mixin convenience.
    private class_5250 getTooltipFormName (PokemonProperties properties) {
        return class_2561.method_43470(StringFormatting.titleCase(properties.getForm())).method_27694(Styles.WHITE_NO_ITALICS);
    }

    // Exists for mixin convenience.
    private class_5250 getTooltipNatureName (PokemonProperties properties) {
        assert properties.getNature() != null;
        return class_2561.method_43470(StringFormatting.titleCase(class_2960.method_60654(properties.getNature()).method_12832())).method_27694(Styles.WHITE_NO_ITALICS);
    }

    // Exists for mixin convenience.
    private class_5250 getTooltipAbilityName (PokemonProperties properties) {
        return class_2561.method_43471("cobblemon.ability." + properties.getAbility()).method_27694(Styles.WHITE_NO_ITALICS);
    }

    public int getRemainingSteps (class_1799 stack) {
        return stack.method_57825(DPItemDataComponents.EGG_STEPS, PokemonEgg.DEFAULT_STEPS);
    }

    public int getMaxSteps (class_1799 stack) {
        return stack.method_57825(DPItemDataComponents.MAX_EGG_STEPS, PokemonEgg.DEFAULT_STEPS);
    }

    @Override
    public int getPolymerCustomModelData (class_1799 stack, @Nullable class_3222 player) {
        if (stack.method_57824(class_9334.field_49637) != null) return -1;
        if (stack.method_57825(DPItemDataComponents.POKEMON_PROPERTIES, "").contains("shiny=true")) return this.shiny.value();
        return super.getPolymerCustomModelData(stack, player);
    }

    private String formatIV (IVs ivs, Stat stat) {
        Integer iv = ivs.get(stat);
        if (iv == null) return "?";
        return String.valueOf(iv);
    }
}
