package com.provismet.cobblemon.daycareplus.item.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1657;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record IncubatorOwner (String playerName, String uuid) {
    public static final Codec<IncubatorOwner> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.STRING.fieldOf("name").forGetter(IncubatorOwner::playerName),
        Codec.STRING.fieldOf("uuid").forGetter(IncubatorOwner::uuid)
    ).apply(instance, IncubatorOwner::new));

    public static final class_9139<class_9129, IncubatorOwner> PACKET_CODEC = class_9139.method_56435(
        class_9135.field_48554,
        IncubatorOwner::playerName,
        class_9135.field_48554,
        IncubatorOwner::uuid,
        IncubatorOwner::new
    );

    public static final IncubatorOwner DEFAULT = new IncubatorOwner("", "");

    public IncubatorOwner (class_1657 player) {
        this(player.method_5477().getString(), player.method_5845());
    }

    public boolean matches (class_1657 player) {
        return this.uuid.equals(player.method_5845());
    }
}
