package com.provismet.cobblemon.daycareplus.item.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record IncubatorType (String tier, String type) {
    public static final Codec<IncubatorType> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.STRING.fieldOf("tier").forGetter(IncubatorType::tier),
        Codec.STRING.fieldOf("type").forGetter(IncubatorType::type)
    ).apply(instance, IncubatorType::new));

    public static final class_9139<class_9129, IncubatorType> PACKET_CODEC = class_9139.method_56435(
        class_9135.field_48554,
        IncubatorType::tier,
        class_9135.field_48554,
        IncubatorType::type,
        IncubatorType::new
    );

    public static final String MAIN_TYPE = "main";
    public static final IncubatorType DEFAULT = IncubatorType.ofMain("copper");

    public static IncubatorType ofMain (String tier) {
        return new IncubatorType(tier, MAIN_TYPE);
    }
}
