/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.breeding;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.CollectEggEvent;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.api.DaycarePlusEvents;
import com.provismet.cobblemon.daycareplus.breeding.BreedingUtils;
import com.provismet.cobblemon.daycareplus.breeding.PastureContainer;
import com.provismet.cobblemon.daycareplus.breeding.PotentialPokemonProperties;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.feature.FertilityProperty;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import com.provismet.cobblemon.daycareplus.util.tag.DPItemTags;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PastureExtension {
    private final UUID uuid;
    private final PokemonPastureBlockEntity blockEntity;
    private long prevTime;
    private int boosts;

    public PastureExtension(PokemonPastureBlockEntity blockEntity, long prevTime, UUID uuid, int boosts) {
        this.blockEntity = blockEntity;
        this.prevTime = prevTime;
        this.uuid = uuid;
        this.boosts = boosts;
    }

    private void tryApplyMirrorHerb(Pokemon potentialHolder, Pokemon other) {
        if (!potentialHolder.heldItem().method_31574((class_1792)CobblemonItems.MIRROR_HERB)) {
            return;
        }
        class_1657 owner = null;
        if (this.blockEntity.getOwnerId() != null && this.blockEntity.method_10997() != null) {
            owner = this.blockEntity.method_10997().method_18470(this.blockEntity.getOwnerId());
        }
        for (Move move : other.getMoveSet()) {
            if (!potentialHolder.getForm().getMoves().getEggMoves().stream().anyMatch(moveTemplate -> moveTemplate.getName().equalsIgnoreCase(move.getName())) || potentialHolder.getMoveSet().getMoves().stream().map(Move::getTemplate).anyMatch(moveTemplate -> moveTemplate.getName().equalsIgnoreCase(move.getName()))) continue;
            boolean alreadyLearnt = false;
            for (BenchedMove benchedMove : potentialHolder.getBenchedMoves()) {
                if (!benchedMove.getMoveTemplate().getName().equalsIgnoreCase(move.getName())) continue;
                alreadyLearnt = true;
                break;
            }
            if (alreadyLearnt || !potentialHolder.getMoveSet().add(move.getTemplate().create()) || owner == null) continue;
            owner.method_43496((class_2561)class_2561.method_43469((String)"message.chat.daycareplus.move_learnt", (Object[])new Object[]{potentialHolder.getDisplayName(), move.getDisplayName()}));
        }
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public int getBoosts() {
        return this.boosts;
    }

    public void setBoosts(int boosts) {
        this.boosts = boosts;
    }

    public Optional<PotentialPokemonProperties> predictEgg() {
        if (this.blockEntity.getTetheredPokemon().size() != 2) {
            return Optional.empty();
        }
        Pokemon parent1 = ((PokemonPastureBlockEntity.Tethering)this.blockEntity.getTetheredPokemon().getFirst()).getPokemon();
        Pokemon parent2 = ((PokemonPastureBlockEntity.Tethering)this.blockEntity.getTetheredPokemon().getLast()).getPokemon();
        return BreedingUtils.getOffspring(parent1, parent2);
    }

    public void produceEgg(PotentialPokemonProperties potentialEgg) {
        class_1657 owner = null;
        if (this.blockEntity.getOwnerId() != null && this.blockEntity.method_10997() != null) {
            owner = this.blockEntity.method_10997().method_18470(this.blockEntity.getOwnerId());
        }
        PokemonProperties properties = potentialEgg.createPokemonProperties();
        if (DaycarePlusOptions.doCompetitiveBreeding()) {
            FertilityProperty.decrement(potentialEgg.getPrimary());
            FertilityProperty.decrement(potentialEgg.getSecondary());
            if (DaycarePlusOptions.shouldConsumeHeldItems()) {
                if (potentialEgg.getPrimary().heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) && !potentialEgg.getPrimary().heldItem().method_31573(DPItemTags.NO_CONSUME_BREEDING)) {
                    potentialEgg.getPrimary().swapHeldItem(class_1799.field_8037, true);
                }
                if (potentialEgg.getSecondary().heldItem().method_31573(DPItemTags.COMPETITIVE_BREEDING) && !potentialEgg.getSecondary().heldItem().method_31573(DPItemTags.NO_CONSUME_BREEDING)) {
                    potentialEgg.getSecondary().swapHeldItem(class_1799.field_8037, true);
                }
            }
            int lower = Math.min(FertilityProperty.get(potentialEgg.getPrimary()), FertilityProperty.get(potentialEgg.getSecondary()));
            properties.getCustomProperties().add(new IntSpeciesFeature("fertility", lower));
        }
        if (owner instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)owner;
            CobblemonEvents.COLLECT_EGG.emit((Cancelable[])new CollectEggEvent[]{new CollectEggEvent(properties, potentialEgg.getPrimary(), potentialEgg.getSecondary(), serverPlayer)});
        }
        ((DaycarePlusEvents.EggProduced.Pre)DaycarePlusEvents.PRE_EGG_PRODUCED.invoker()).beforeItemCreated(properties);
        class_1799 egg = DPItems.POKEMON_EGG.createEggItem(properties);
        ((DaycarePlusEvents.EggProduced.Post)DaycarePlusEvents.POST_EGG_PRODUCED.invoker()).afterItemCreated(egg);
        ((PastureContainer)this.blockEntity).add(egg);
    }

    public void tick() {
        class_1937 class_19372 = this.blockEntity.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (world.method_8510() % 20L == 0L) {
                world.method_14199((class_2394)class_2398.field_11201, (double)this.blockEntity.method_11016().method_10263() + 0.5, (double)this.blockEntity.method_11016().method_10264() + 1.5, (double)this.blockEntity.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
            long ticksToProcess = Math.max(0L, world.method_8510() - this.prevTime);
            this.prevTime = world.method_8510();
            long eggAttempts = ticksToProcess / DaycarePlusOptions.getTicksPerEggAttempt();
            if ((world.method_8510() + this.uuid.getLeastSignificantBits()) % DaycarePlusOptions.getTicksPerEggAttempt() == 0L) {
                ++eggAttempts;
            }
            int calculatedEggs = 0;
            class_1657 owner = null;
            boolean applyMirrorHerb = false;
            if (this.blockEntity.getOwnerId() != null) {
                owner = this.blockEntity.method_10997().method_18470(this.blockEntity.getOwnerId());
            }
            int i = 0;
            while ((long)i < eggAttempts) {
                if (!(world.method_8409().method_43058() > DaycarePlusOptions.getSuccessRatePerEggAttempt())) {
                    applyMirrorHerb = true;
                    int eggsToProduce = 1;
                    if (this.boosts > 0) {
                        eggsToProduce = 2;
                        --this.boosts;
                    }
                    for (int j = 0; j < eggsToProduce; ++j) {
                        Optional<PotentialPokemonProperties> optionalEgg = this.predictEgg();
                        if (!optionalEgg.isPresent()) continue;
                        if (owner != null) {
                            if (eggAttempts == 1L) {
                                owner.method_43496((class_2561)class_2561.method_43471((String)"message.chat.daycareplus.egg_produced"));
                            } else {
                                ++calculatedEggs;
                            }
                        }
                        this.produceEgg(optionalEgg.get());
                    }
                }
                ++i;
            }
            if (applyMirrorHerb && !this.blockEntity.getTetheredPokemon().isEmpty()) {
                Pokemon parent1 = ((PokemonPastureBlockEntity.Tethering)this.blockEntity.getTetheredPokemon().getFirst()).getPokemon();
                Pokemon parent2 = ((PokemonPastureBlockEntity.Tethering)this.blockEntity.getTetheredPokemon().getLast()).getPokemon();
                if (parent1 != null && parent2 != null) {
                    this.tryApplyMirrorHerb(parent1, parent2);
                    this.tryApplyMirrorHerb(parent2, parent1);
                }
            }
            if ((calculatedEggs = class_3532.method_15340((int)calculatedEggs, (int)0, (int)DaycarePlusOptions.getPastureInventorySize())) > 0 && owner != null) {
                if (calculatedEggs == 1) {
                    owner.method_43496((class_2561)class_2561.method_43469((String)"message.chat.daycareplus.single_egg_produced", (Object[])new Object[]{calculatedEggs}));
                } else {
                    owner.method_43496((class_2561)class_2561.method_43469((String)"message.chat.daycareplus.multiple_egg_produced", (Object[])new Object[]{calculatedEggs}));
                }
            }
        }
    }
}

