/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.provismet.cobblemon.daycareplus.DaycarePlusMain;
import com.provismet.lilylib.util.json.JsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class IncubatorTiers {
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("daycareplus").resolve("incubators.json");
    private static final Map<String, IncubatorSettings> settings = new HashMap<String, IncubatorSettings>();
    private static final IncubatorSettings COPPER = new IncubatorSettings(8, 1);
    private static final IncubatorSettings IRON = new IncubatorSettings(64, 2);
    private static final IncubatorSettings GOLD = new IncubatorSettings(32, 32);
    private static final IncubatorSettings DIAMOND = new IncubatorSettings(96, 4);
    private static final IncubatorSettings NETHERITE = new IncubatorSettings(128, 8);

    public static Optional<IncubatorSettings> get(String tier) {
        return Optional.ofNullable(settings.get(tier));
    }

    public static Set<String> getTiers() {
        return settings.keySet();
    }

    public static void load() {
        settings.putIfAbsent("copper", COPPER);
        settings.putIfAbsent("iron", IRON);
        settings.putIfAbsent("gold", GOLD);
        settings.putIfAbsent("diamond", DIAMOND);
        settings.putIfAbsent("netherite", NETHERITE);
        if (!FILE.toFile().exists()) {
            IncubatorTiers.save();
        }
        try {
            JsonElement element = JsonParser.parseReader((Reader)new FileReader(FILE.toFile()));
            if (!(element instanceof JsonObject)) {
                IncubatorTiers.save();
                return;
            }
            JsonObject json = (JsonObject)element;
            for (Map.Entry entry : json.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)v;
                settings.put((String)entry.getKey(), IncubatorSettings.fromJson(jsonObject));
            }
        }
        catch (FileNotFoundException e) {
            DaycarePlusMain.LOGGER.info("No Daycare+ incubator config found, creating default.");
        }
        catch (Exception e) {
            DaycarePlusMain.LOGGER.error("Error reading Daycare+ incubator config: ", (Throwable)e);
        }
        IncubatorTiers.save();
    }

    public static void save() {
        JsonBuilder builder = new JsonBuilder();
        for (Map.Entry<String, IncubatorSettings> entry : settings.entrySet()) {
            builder.append(entry.getKey(), (JsonElement)entry.getValue().toJson());
        }
        try (FileWriter writer = new FileWriter(FILE.toFile());){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)builder.getJson()));
        }
        catch (IOException e) {
            DaycarePlusMain.LOGGER.error("Error whilst saving config: ", (Throwable)e);
        }
    }

    public record IncubatorSettings(int capacity, int eggsToTick) {
        public static IncubatorSettings fromJson(JsonObject json) {
            int capacity = 1;
            int eggs = 1;
            if (json.has("capacity")) {
                capacity = json.getAsJsonPrimitive("capacity").getAsInt();
            }
            if (json.has("eggs_to_tick_simultaneously")) {
                eggs = json.getAsJsonPrimitive("eggs_to_tick_simultaneously").getAsInt();
            }
            return new IncubatorSettings(capacity, eggs);
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("capacity", (Number)this.capacity);
            json.addProperty("eggs_to_tick_simultaneously", (Number)this.eggsToTick);
            return json;
        }
    }
}

