/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.gui;

import com.provismet.cobblemon.daycareplus.registries.DPIconItems;
import com.provismet.cobblemon.daycareplus.storage.EggStorage;
import com.provismet.cobblemon.daycareplus.storage.IncubatorCollection;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public class EggStorageGUI
extends SimpleGui {
    private static final int ITEMS_PER_ROW = 9;
    private static final int ROWS_PER_PAGE = 5;
    private static final int ITEMS_PER_PAGE = 45;
    private final EggStorage storage;
    private int minSlotDisplayed;
    private boolean isAtEnd;

    protected EggStorageGUI(class_3222 player, EggStorage storage) {
        super(class_3917.field_17327, player, false);
        this.storage = storage;
    }

    public static EggStorageGUI create(class_3222 player, String storageName) {
        Optional<EggStorage> storage = IncubatorCollection.getOrCreate((class_1657)player).get(storageName);
        if (storage.isPresent()) {
            EggStorageGUI gui = new EggStorageGUI(player, storage.get());
            gui.updateBorder();
            gui.loadPage();
            gui.setTitle((class_2561)class_2561.method_43471((String)"gui.title.daycareplus.incubator"));
            return gui;
        }
        return null;
    }

    private void updateBorder() {
        GuiElement borderFiller = GuiElementBuilder.from((class_1799)class_1802.field_8157.method_7854()).hideDefaultTooltip().hideTooltip().build();
        for (int i = 0; i < 9; ++i) {
            this.setSlot(i, (GuiElementInterface)borderFiller);
        }
        GuiElement prev = GuiElementBuilder.from((class_1799)DPIconItems.LEFT.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.prev").method_27694(Styles.WHITE_NO_ITALICS)).setCallback((index, clickType, action, gui) -> this.previousPage()).build();
        GuiElement next = GuiElementBuilder.from((class_1799)DPIconItems.RIGHT.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.next").method_27694(Styles.WHITE_NO_ITALICS)).setCallback((index, clickType, action, gui) -> this.nextPage()).build();
        GuiElement take = GuiElementBuilder.from((class_1799)DPIconItems.TAKE_ALL.method_7854()).setName((class_2561)class_2561.method_43471((String)"gui.button.daycareplus.take").method_27694(Styles.WHITE_NO_ITALICS)).setCallback((index, type1, action, gui) -> {
            this.player.method_31548().field_7547.forEach(this.storage::addCopyAndEmpty);
            this.player.method_17356(class_3417.field_34376, class_3419.field_15248, 1.0f, 1.0f);
            this.loadPage();
        }).build();
        this.setSlot(0, (GuiElementInterface)prev);
        this.setSlot(7, (GuiElementInterface)take);
        this.setSlot(8, (GuiElementInterface)next);
    }

    private void loadPage() {
        int i = 0;
        while (i + 9 < this.getVirtualSize()) {
            int storageIndex = this.minSlotDisplayed + i;
            GuiElement eggButton = storageIndex < this.storage.size() ? GuiElementBuilder.from((class_1799)this.storage.getItem(this.minSlotDisplayed + i)).setCallback((index, clickType, action, gui) -> {
                class_1799 stack = this.storage.getItem(storageIndex);
                if (!stack.method_7960() && this.player.method_7270(stack)) {
                    this.storage.remove(storageIndex);
                    this.player.method_17356(class_3417.field_34377, class_3419.field_15248, 1.0f, 1.0f);
                    this.loadPage();
                }
            }).build() : GuiElementBuilder.from((class_1799)class_1799.field_8037).build();
            this.setSlot(i + 9, (GuiElementInterface)eggButton);
            ++i;
        }
        this.isAtEnd = this.minSlotDisplayed + 45 > this.storage.size();
    }

    private void nextPage() {
        if (!this.isAtEnd) {
            this.minSlotDisplayed += 45;
            this.loadPage();
        }
    }

    private void previousPage() {
        if (this.minSlotDisplayed > 0) {
            this.minSlotDisplayed = Math.max(0, this.minSlotDisplayed - 45);
            this.loadPage();
        }
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (index >= 54) {
            int inventoryIndex = index >= 81 ? index - 81 : index - 45;
            if (inventoryIndex < this.player.method_31548().field_7547.size()) {
                this.storage.addCopyAndEmpty((class_1799)this.player.method_31548().field_7547.get(inventoryIndex));
            }
            this.loadPage();
        }
        return super.onAnyClick(index, type, action);
    }

    public void onTick() {
        if (this.player.field_6012 % 20 == 1) {
            this.loadPage();
        }
    }
}

