/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.breeding;

import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3222;

public class BreedingLink {
    private static final Map<String, Set<String>> link = new HashMap<String, Set<String>>();

    public static int count(class_3222 player) {
        return BreedingLink.count(player.method_5667());
    }

    public static int count(UUID playerUuid) {
        return link.getOrDefault(playerUuid.toString(), Set.of()).size();
    }

    public static boolean isAtLimit(UUID player) {
        return BreedingLink.count(player) >= DaycarePlusOptions.getMaxPasturesPerPlayer();
    }

    public static boolean isAtLimit(class_3222 player) {
        return BreedingLink.isAtLimit(player.method_5667());
    }

    public static boolean add(UUID player, UUID daycareId) {
        if (BreedingLink.isAtLimit(player)) {
            return false;
        }
        link.computeIfAbsent(player.toString(), playerUuid -> new HashSet()).add(daycareId.toString());
        return true;
    }

    public static boolean add(class_3222 player, UUID daycareId) {
        return BreedingLink.add(player.method_5667(), daycareId);
    }

    public static void remove(UUID player, UUID daycareId) {
        link.computeIfAbsent(player.toString(), playerUuid -> new HashSet()).remove(daycareId.toString());
    }

    public static void remove(class_3222 player, UUID daycareId) {
        BreedingLink.remove(player.method_5667(), daycareId);
    }

    public static void remove(class_3222 player) {
        link.remove(player.method_5667().toString());
    }

    public static boolean has(UUID player, UUID daycareId) {
        return link.getOrDefault(player.toString(), Set.of()).contains(daycareId.toString());
    }

    public static boolean has(class_3222 player, UUID daycareId) {
        return BreedingLink.has(player.method_5667(), daycareId);
    }
}

