/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.feature;

import com.cobblemon.mod.common.api.properties.CustomPokemonPropertyType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.BooleanProperty;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreedableProperty
implements CustomPokemonPropertyType<BooleanProperty> {
    private static final String KEY = "breedable";

    public BooleanProperty create(boolean value) {
        return new BooleanProperty(KEY, value, BreedableProperty::applyToPokemon, BreedableProperty::applyToPokemonEntity, BreedableProperty::matchPokemon, BreedableProperty::matchPokemonEntity);
    }

    public static boolean get(Pokemon pokemon) {
        return BreedableProperty.matchPokemon(pokemon, true);
    }

    private static Unit applyToPokemon(Pokemon pokemon, boolean value) {
        pokemon.getPersistentData().method_10556(KEY, value);
        pokemon.getAnyChangeObservable().emit((Object[])new Pokemon[]{pokemon});
        return Unit.INSTANCE;
    }

    private static Unit applyToPokemonEntity(PokemonEntity pokemon, boolean value) {
        return BreedableProperty.applyToPokemon(pokemon.getPokemon(), value);
    }

    private static boolean matchPokemon(Pokemon pokemon, boolean value) {
        if (pokemon.getPersistentData().method_10545(KEY)) {
            return pokemon.getPersistentData().method_10577(KEY) == value;
        }
        return true;
    }

    private static boolean matchPokemonEntity(PokemonEntity pokemon, boolean value) {
        return BreedableProperty.matchPokemon(pokemon.getPokemon(), value);
    }

    @NotNull
    public Iterable<String> getKeys() {
        return List.of(KEY);
    }

    public boolean getNeedsKey() {
        return true;
    }

    @Nullable
    public BooleanProperty fromString(@Nullable String stringValue) {
        if (stringValue == null) {
            return null;
        }
        boolean value = "true".equalsIgnoreCase(stringValue) || "yes".equalsIgnoreCase(stringValue);
        return this.create(value);
    }

    @NotNull
    public Collection<String> examples() {
        return List.of("true", "false");
    }
}

