/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.feature;

import com.cobblemon.mod.common.api.pokemon.feature.GlobalSpeciesFeatures;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SynchronizedSpeciesFeature;
import com.cobblemon.mod.common.net.messages.client.PokemonUpdatePacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.SpeciesFeatureUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;

public class FertilityProperty {
    public static final String KEY = "fertility";

    public static int get(Pokemon pokemon) {
        if (!DaycarePlusOptions.doCompetitiveBreeding()) {
            return FertilityProperty.getMax();
        }
        IntSpeciesFeature fertilityFeature = (IntSpeciesFeature)pokemon.getFeature(KEY);
        if (fertilityFeature == null) {
            return FertilityProperty.getMax();
        }
        return fertilityFeature.getValue();
    }

    public static int getMax() {
        SpeciesFeatureProvider fertilityProvider = GlobalSpeciesFeatures.INSTANCE.getFeature(KEY);
        if (fertilityProvider instanceof IntSpeciesFeatureProvider) {
            IntSpeciesFeatureProvider intProvider = (IntSpeciesFeatureProvider)fertilityProvider;
            return intProvider.getMax();
        }
        return 0;
    }

    public static void increment(Pokemon pokemon) {
        new IntSpeciesFeature(KEY, FertilityProperty.get(pokemon) + 1).apply(pokemon);
        FertilityProperty.update(pokemon);
    }

    public static void decrement(Pokemon pokemon) {
        new IntSpeciesFeature(KEY, FertilityProperty.get(pokemon) - 1).apply(pokemon);
        FertilityProperty.update(pokemon);
    }

    public static void update(Pokemon pokemon) {
        if (DaycarePlusOptions.doCompetitiveBreeding()) {
            pokemon.notify((PokemonUpdatePacket)new SpeciesFeatureUpdatePacket(() -> pokemon, pokemon.getSpecies().resourceIdentifier, (SynchronizedSpeciesFeature)new IntSpeciesFeature(KEY, FertilityProperty.get(pokemon))));
        }
    }
}

