/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.mixin;

import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.breeding.BreedingLink;
import com.provismet.cobblemon.daycareplus.breeding.PastureExtension;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.gui.DaycareGUI;
import com.provismet.cobblemon.daycareplus.imixin.IMixinPastureBlockEntity;
import com.provismet.cobblemon.daycareplus.util.Styles;
import eu.pb4.sgui.api.elements.GuiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonPastureBlockEntity.class})
public abstract class PastureBlockEntityMixin
extends class_2586
implements IMixinPastureBlockEntity {
    @Unique
    private boolean isBreeder = false;
    @Unique
    private UUID breederUuid = null;
    @Unique
    private boolean skipIntroDialogue = false;
    @Unique
    private boolean skipDaycareGUI = false;
    @Unique
    private PastureExtension extension;
    @Unique
    private class_2371<class_1799> inventory = class_2371.method_10213((int)DaycarePlusOptions.getPastureInventorySize(), (Object)class_1799.field_8037);
    @Unique
    private GuiElement eggCounter = DaycareGUI.createEggButton(this);
    @Unique
    private GuiElement boostCounter = DaycareGUI.createBoostButton(this);

    public PastureBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Shadow
    public abstract UUID getOwnerId();

    @Override
    public PastureExtension getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(PastureExtension extension) {
        this.extension = extension;
    }

    @Override
    public void setShouldBreed(boolean shouldBreed) {
        this.isBreeder = shouldBreed;
    }

    @Override
    public boolean shouldBreed() {
        return this.isBreeder;
    }

    @Override
    public void setSkipIntroDialogue(boolean skipIntroDialogue) {
        this.skipIntroDialogue = skipIntroDialogue;
    }

    @Override
    public boolean shouldSkipIntro() {
        return this.skipIntroDialogue;
    }

    @Override
    public void setShouldSkipDaycareGUI(boolean skipGUI) {
        this.skipDaycareGUI = skipGUI;
    }

    @Override
    public boolean shouldSkipDaycareGUI() {
        return this.skipDaycareGUI;
    }

    @Override
    public GuiElement getEggCounterButton() {
        this.updateEggCounter();
        return this.eggCounter;
    }

    @Override
    public GuiElement getBoostCounterButton() {
        this.updateBoostCounter();
        return this.boostCounter;
    }

    @Override
    public UUID getBreederUUID() {
        return this.breederUuid;
    }

    @Override
    public void setBreederUUID(UUID uuid) {
        this.breederUuid = uuid;
    }

    @Override
    public void add(class_1799 stack) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (!((class_1799)this.inventory.get(i)).method_7960()) continue;
            this.inventory.set(i, (Object)stack.method_51164());
            this.method_5431();
            this.updateEggCounter();
            this.updateBoostCounter();
            break;
        }
    }

    @Override
    public List<class_1799> withdraw(int amount) {
        if (this.method_5442()) {
            return List.of();
        }
        ArrayList<class_1799> withdrawn = new ArrayList<class_1799>();
        for (int i = 0; i < this.inventory.size() && withdrawn.size() < amount; ++i) {
            class_1799 egg = this.method_5438(i);
            if (egg.method_7960()) continue;
            withdrawn.add(egg.method_7972());
            this.method_5447(i, class_1799.field_8037);
        }
        return withdrawn;
    }

    @Override
    public int count() {
        int heldEggs = 0;
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            ++heldEggs;
        }
        return heldEggs;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
            this.updateEggCounter();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = (class_1799)this.inventory.get(slot);
        this.inventory.set(slot, (Object)class_1799.field_8037);
        if (!stack.method_7960()) {
            this.method_5431();
            this.updateEggCounter();
        }
        return stack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
        this.updateEggCounter();
        this.updateBoostCounter();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
        this.updateEggCounter();
    }

    @Unique
    private void updateEggCounter() {
        this.eggCounter.getItemStack().method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)"gui.button.daycareplus.eggs_held", (Object[])new Object[]{this.count(), this.method_5439()}).method_27694(Styles.WHITE_NO_ITALICS));
    }

    @Unique
    private void updateBoostCounter() {
        this.boostCounter.getItemStack().method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)"gui.button.daycareplus.boosts_remaining", (Object[])new Object[]{this.getExtension() != null ? this.getExtension().getBoosts() : 0}).method_27694(Styles.WHITE_NO_ITALICS));
    }

    @Inject(method={"TICKER$lambda$14"}, at={@At(value="HEAD")})
    private static void tick(class_1937 world, class_2338 pos, class_2680 blockState, PokemonPastureBlockEntity pasture, CallbackInfo info) {
        if (world.method_8608()) {
            return;
        }
        IMixinPastureBlockEntity imixin = (IMixinPastureBlockEntity)pasture;
        if (imixin.shouldBreed()) {
            if (imixin.getBreederUUID() == null) {
                imixin.setBreederUUID(UUID.randomUUID());
            }
            if (pasture.getOwnerId() != null && !BreedingLink.has(pasture.getOwnerId(), imixin.getBreederUUID()) && !BreedingLink.add(pasture.getOwnerId(), imixin.getBreederUUID())) {
                imixin.setShouldBreed(false);
                imixin.setExtension(null);
                return;
            }
            if (pasture.getOwnerId() != null && BreedingLink.count(pasture.getOwnerId()) > DaycarePlusOptions.getMaxPasturesPerPlayer()) {
                imixin.setShouldBreed(false);
                imixin.setExtension(null);
                BreedingLink.remove(pasture.getOwnerId(), imixin.getBreederUUID());
                return;
            }
            if (imixin.getExtension() == null) {
                imixin.setExtension(new PastureExtension(pasture, Long.MAX_VALUE, imixin.getBreederUUID(), 0));
            }
            imixin.getExtension().tick();
        } else {
            imixin.setExtension(null);
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="TAIL")})
    private void addNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfo info) {
        class_2487 breederNbt = new class_2487();
        breederNbt.method_10556("isBreeder", this.isBreeder);
        breederNbt.method_25927("uuid", Objects.requireNonNullElseGet(this.breederUuid, UUID::randomUUID));
        if (this.extension != null) {
            breederNbt.method_10544("prevTick", this.extension.getPrevTime());
        } else if (this.field_11863 != null) {
            breederNbt.method_10544("prevTick", this.field_11863.method_8510());
        } else {
            breederNbt.method_10544("prevTick", Long.MAX_VALUE);
        }
        if (this.extension != null) {
            breederNbt.method_10569("boosts", this.extension.getBoosts());
        } else {
            breederNbt.method_10569("boosts", 0);
        }
        class_1262.method_5426((class_2487)breederNbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10566("daycarePlus", (class_2520)breederNbt);
    }

    @Inject(method={"readNbt"}, at={@At(value="TAIL")})
    private void getNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfo info) {
        class_2520 class_25202;
        if (nbt.method_10545("daycarePlus") && (class_25202 = nbt.method_10580("daycarePlus")) instanceof class_2487) {
            class_2487 daycareNbt = (class_2487)class_25202;
            if (daycareNbt.method_10545("isBreeder")) {
                this.isBreeder = daycareNbt.method_10577("isBreeder");
            }
            this.breederUuid = daycareNbt.method_10545("uuid") ? daycareNbt.method_25926("uuid") : UUID.randomUUID();
            if (this.isBreeder) {
                long prevTick = Long.MAX_VALUE;
                int boosts = 0;
                if (daycareNbt.method_10545("prevTick")) {
                    prevTick = daycareNbt.method_10537("prevTick");
                }
                if (daycareNbt.method_10545("boosts")) {
                    boosts = daycareNbt.method_10550("boosts");
                }
                this.extension = new PastureExtension((PokemonPastureBlockEntity)this, prevTick, this.breederUuid, boosts);
            }
            this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)daycareNbt, this.inventory, (class_7225.class_7874)registryLookup);
        }
    }

    @Inject(method={"onBroken"}, at={@At(value="HEAD")}, remap=false)
    private void spillInventory(CallbackInfo info) {
        if (this.field_11863 == null) {
            return;
        }
        for (class_1799 stack : this.inventory) {
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)stack.method_51164());
        }
        if (this.getOwnerId() != null && this.breederUuid != null) {
            BreedingLink.remove(this.getOwnerId(), this.breederUuid);
        }
    }

    @Inject(method={"getMaxTethered"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void restrictDaycare(CallbackInfoReturnable<Integer> cir) {
        if (this.isBreeder) {
            cir.setReturnValue((Object)2);
        }
    }
}

