/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.daycareplus.api;

import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.daycareplus.api.DaycarePlusEvents;
import com.provismet.cobblemon.daycareplus.config.DaycarePlusOptions;
import com.provismet.cobblemon.daycareplus.registries.DPItemDataComponents;
import com.provismet.cobblemon.daycareplus.registries.DPItems;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PokemonEgg {
    public static final int DEFAULT_STEPS = 7200;
    public static final Codec<PokemonEgg> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("pokemon", (Object)"random level=1").forGetter(PokemonEgg::getPropertyString), (App)Codec.INT.optionalFieldOf("steps", (Object)7200).forGetter(PokemonEgg::getSteps), (App)Codec.INT.optionalFieldOf("max_steps", (Object)7200).forGetter(PokemonEgg::getMaxSteps), (App)Codec.BOOL.optionalFieldOf("hatched", (Object)false).forGetter(PokemonEgg::isHatched)).apply((Applicative)instance, PokemonEgg::new));
    private final String propertyString;
    private final int maxSteps;
    private int steps;
    private PokemonProperties pokemonProperties;
    private boolean hatched;

    public PokemonEgg(String pokemonProperties, int steps, int maxSteps, boolean hatched) {
        this.propertyString = pokemonProperties;
        this.maxSteps = maxSteps;
        this.steps = steps;
        this.hatched = hatched;
        this.pokemonProperties = null;
    }

    public PokemonEgg(PokemonProperties pokemonProperties, int steps, int maxSteps, boolean hatched) {
        this.pokemonProperties = pokemonProperties;
        this.propertyString = pokemonProperties.asString(" ");
        this.maxSteps = maxSteps;
        this.steps = steps;
        this.hatched = hatched;
    }

    public PokemonEgg(PokemonProperties pokemonProperties) {
        this.pokemonProperties = pokemonProperties;
        this.propertyString = pokemonProperties.asString(" ");
        this.hatched = false;
        if (pokemonProperties.getSpecies() != null) {
            class_2960 speciesId = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)pokemonProperties.getSpecies(), (String)"cobblemon");
            Species species = PokemonSpecies.getByIdentifier((class_2960)speciesId);
            if (species != null) {
                this.maxSteps = this.steps = DaycarePlusOptions.getEggPoints(species.getEggCycles());
            } else {
                this.steps = 7200;
                this.maxSteps = 7200;
            }
        } else {
            this.steps = 7200;
            this.maxSteps = 7200;
        }
    }

    public String getPropertyString() {
        return this.propertyString;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public boolean isHatched() {
        return this.hatched;
    }

    public class_1799 getItem() {
        class_1799 stack = DPItems.POKEMON_EGG.method_7854();
        stack.method_57379(DPItemDataComponents.POKEMON_PROPERTIES, (Object)this.getPropertyString());
        if (this.pokemonProperties == null) {
            this.pokemonProperties = PokemonProperties.Companion.parse(this.propertyString);
        }
        stack.method_57379(DPItemDataComponents.EGG_STEPS, (Object)this.steps);
        stack.method_57379(DPItemDataComponents.MAX_EGG_STEPS, (Object)this.maxSteps);
        if (this.steps < this.maxSteps) {
            stack.method_7974(class_3532.method_48781((float)(1.0f - (float)this.steps / (float)this.maxSteps), (int)1, (int)100));
        }
        ((DaycarePlusEvents.EggProduced.Post)DaycarePlusEvents.POST_EGG_PRODUCED.invoker()).afterItemCreated(stack);
        return stack;
    }

    public void decrementEggSteps(int amount, class_3222 player) {
        this.steps = Math.max(0, this.steps - amount);
        if (this.steps == 0) {
            boolean partyHasSpace;
            boolean playerPartyBusy = PlayerExtensionsKt.isPartyBusy((class_1657)player) || PlayerExtensionsKt.isInBattle((class_3222)player);
            boolean bl = partyHasSpace = PlayerExtensionsKt.party((class_3222)player).getFirstAvailablePosition() != null || PlayerExtensionsKt.pc((class_3222)player).getFirstAvailablePosition() != null;
            if (!playerPartyBusy && partyHasSpace) {
                this.hatch(player);
            }
        }
    }

    public void hatch(class_3222 player) {
        if (this.pokemonProperties == null) {
            this.pokemonProperties = PokemonProperties.Companion.parse(this.propertyString);
        }
        CobblemonEvents.HATCH_EGG_PRE.emit((Cancelable[])new HatchEggEvent.Pre[]{new HatchEggEvent.Pre(this.pokemonProperties, player)});
        Pokemon pokemon = this.pokemonProperties.create(player);
        pokemon.getAbility().setForced$common(false);
        player.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.daycareplus.egg.hatch"), true);
        PlayerExtensionsKt.party((class_3222)player).add(pokemon);
        CobblemonEvents.HATCH_EGG_POST.emit((Object[])new HatchEggEvent.Post[]{new HatchEggEvent.Post(player, pokemon)});
        this.hatched = true;
    }
}

