/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.statisticsupdater;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2214;
import net.minecraft.class_2233;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_5218;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class StatisticsUpdater
implements ModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scoreboard").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"objectives").then(class_2170.method_9247((String)"update").then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(context -> {
            class_266 objective = class_2214.method_9395((CommandContext)context, (String)"objective");
            if (!(objective.method_1116() instanceof class_3445)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Objective criteria is not a statistic")).create();
            }
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            class_11561 profileCache = server.method_73550().comp_4407();
            class_269 scoreboard = objective.method_1117();
            Map<UUID, class_3442> stats = this.getPlayerStats(server);
            AtomicInteger missingPlayers = new AtomicInteger();
            stats.forEach((uuid, playerStats) -> {
                int statsValue = playerStats.method_15025((class_3445)objective.method_1116());
                if (statsValue == 0) {
                    return;
                }
                class_9015 scoreHolder = profileCache.method_14512(uuid).map(nameAndId -> new GameProfile(nameAndId.comp_4422(), nameAndId.comp_4423())).map(class_9015::method_55420).orElseGet(() -> {
                    missingPlayers.incrementAndGet();
                    LOGGER.warn("Couldn't find a player name for UUID {} while updating objective {}", uuid, (Object)objective.method_1113());
                    return class_9015.method_55422((String)uuid.toString());
                });
                scoreboard.method_1180(scoreHolder, objective).method_55410(statsValue);
            });
            ((class_2168)context.getSource()).method_9226(() -> {
                if (missingPlayers.get() > 0) {
                    return class_2561.method_43470((String)("Updated values for all players for " + objective.method_1113() + ". Not all UUIDs could be fetched; please read the logs for more information"));
                }
                return class_2561.method_43470((String)("Updated values for all players for " + objective.method_1113()));
            }, true);
            return missingPlayers.get();
        }))))).then(class_2170.method_9247((String)"players").then(class_2170.method_9247((String)"update").then(class_2170.method_9244((String)"player", (ArgumentType)class_2233.method_9447()).executes(context -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            class_11561 profileCache = server.method_73550().comp_4407();
            class_9015 scoreHolder = class_2233.method_9452((CommandContext)context, (String)"player");
            UUID uuid = profileCache.method_14515(scoreHolder.method_5820()).map(class_11560::comp_4422).orElseThrow(() -> new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No UUID could be found for the given player")).create());
            class_3442 stats = this.getPlayerStats(server).get(uuid);
            if (stats == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No statistics found for the given player")).create();
            }
            server.method_3845().method_1151().forEach(objective -> {
                class_3445 stat;
                class_274 patt0$temp = objective.method_1116();
                if (patt0$temp instanceof class_3445 && stats.method_15025(stat = (class_3445)patt0$temp) != 0) {
                    server.method_3845().method_1180(scoreHolder, objective).method_55410(stats.method_15025(stat));
                }
            });
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Updated scores for " + scoreHolder.method_5820())), true);
            return 0;
        }))))));
    }

    private Map<UUID, class_3442> getPlayerStats(MinecraftServer server) {
        File statsDir = server.method_27050(class_5218.field_24181).toFile();
        File[] statsFiles = statsDir.listFiles();
        if (statsFiles == null) {
            return Map.of();
        }
        HashMap<UUID, class_3442> statsCounters = new HashMap<UUID, class_3442>();
        for (File statsFile : statsFiles) {
            UUID uuid = UUID.fromString(statsFile.getName().replace(".json", ""));
            class_3442 playerStat = new class_3442(server, statsFile);
            statsCounters.put(uuid, playerStat);
        }
        return statsCounters;
    }
}

