/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.addons;

import de.bluecolored.bluemap.common.addons.Addon;
import de.bluecolored.bluemap.common.addons.AddonInfo;
import de.bluecolored.bluemap.common.addons.CombinedClassLoader;
import de.bluecolored.bluemap.common.addons.LoadedAddon;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class AddonLoader {
    public static final AddonLoader INSTANCE = new AddonLoader();
    private final Map<String, LoadedAddon> loadedAddons = new ConcurrentHashMap<String, LoadedAddon>();

    public void tryLoadAddons(Path root) {
        if (!Files.exists(root, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(root);){
            Addon addonToRemove;
            Map<String, Addon> availableAddons = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().endsWith(".jar")).map(this::tryLoadAddonInfo).filter(Objects::nonNull).collect(Collectors.toMap(addon -> addon.getAddonInfo().getId(), addon -> addon));
            while (!availableAddons.isEmpty() && (addonToRemove = (Addon)availableAddons.values().stream().filter(a -> !availableAddons.keySet().containsAll(a.getAddonInfo().getDependencies())).findAny().orElse(null)) != null) {
                String id = addonToRemove.getAddonInfo().getId();
                availableAddons.remove(id);
                new ConfigurationException("Missing required dependencies %s to load addon '%s' (%s)".formatted(Arrays.toString(addonToRemove.getAddonInfo().getDependencies().toArray(String[]::new)), id, addonToRemove.getJarFile())).printLog(Logger.global);
            }
            HashMap<String, Long> dependenciesToLoad = new HashMap<String, Long>();
            ArrayDeque<String> loadNext = new ArrayDeque<String>();
            for (Addon addon2 : availableAddons.values()) {
                long dependencyCount = (long)addon2.getAddonInfo().getDependencies().size() + addon2.getAddonInfo().getSoftDependencies().stream().filter(availableAddons::containsKey).count();
                String id = addon2.getAddonInfo().getId();
                if (dependencyCount == 0L) {
                    loadNext.add(id);
                    continue;
                }
                dependenciesToLoad.put(id, dependencyCount);
            }
            while (!loadNext.isEmpty()) {
                Addon addon2;
                String id = (String)loadNext.poll();
                addon2 = availableAddons.get(id);
                try {
                    this.loadAddon(addon2);
                    for (Addon dependant : availableAddons.values()) {
                        Long count;
                        AddonInfo info = dependant.getAddonInfo();
                        if (!info.getDependencies().contains(id) && !info.getSoftDependencies().contains(id) || (count = (Long)dependenciesToLoad.get(info.getId())) == null) continue;
                        if ((count = Long.valueOf(count - 1L)) <= 0L) {
                            dependenciesToLoad.remove(info.getId());
                            loadNext.add(info.getId());
                            continue;
                        }
                        dependenciesToLoad.put(info.getId(), count);
                    }
                }
                catch (ConfigurationException ex) {
                    new ConfigurationException("Failed to load addon '%s' (%s)".formatted(id, addon2.getJarFile()), ex).printLog(Logger.global);
                }
            }
            for (String id : dependenciesToLoad.keySet()) {
                Addon addon3 = availableAddons.remove(id);
                try {
                    if (addon3 == null) continue;
                    this.loadAddon(addon3);
                }
                catch (ConfigurationException ex) {
                    new ConfigurationException("Failed to load addon '%s' (%s)".formatted(id, addon3.getJarFile()), ex).printLog(Logger.global);
                }
            }
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load addons from '%s'".formatted(root), e);
        }
    }

    @Nullable
    private Addon tryLoadAddonInfo(Path jarFile) {
        try {
            AddonInfo addonInfo = AddonInfo.load(jarFile);
            if (addonInfo == null) {
                return null;
            }
            return new Addon(addonInfo, jarFile);
        }
        catch (ConfigurationException e) {
            new ConfigurationException("Failed to load addon info from '%s'.".formatted(jarFile), e).printLog(Logger.global);
            return null;
        }
    }

    private synchronized void loadAddon(Addon addon) throws ConfigurationException {
        AddonInfo addonInfo = addon.getAddonInfo();
        Path jarFile = addon.getJarFile();
        if (this.loadedAddons.containsKey(addonInfo.getId())) {
            return;
        }
        Logger.global.logInfo("Loading BlueMap Addon: %s (%s)".formatted(addonInfo.getId(), jarFile));
        try {
            LoadedAddon loadedAddon;
            LinkedHashSet<ClassLoader> dependencyClassLoaders = new LinkedHashSet<ClassLoader>();
            for (String dependencyId : addon.getAddonInfo().getDependencies()) {
                loadedAddon = this.loadedAddons.get(dependencyId);
                if (loadedAddon == null) {
                    throw new IllegalStateException("Required dependency '%s' is not loaded.".formatted(addon.getAddonInfo().getId()));
                }
                dependencyClassLoaders.add(loadedAddon.getClassLoader());
            }
            for (String dependencyId : addon.getAddonInfo().getSoftDependencies()) {
                loadedAddon = this.loadedAddons.get(dependencyId);
                if (loadedAddon == null) continue;
                dependencyClassLoaders.add(loadedAddon.getClassLoader());
            }
            ClassLoader parent = BlueMap.class.getClassLoader();
            if (!dependencyClassLoaders.isEmpty()) {
                parent = new CombinedClassLoader(parent, (ClassLoader[])dependencyClassLoaders.toArray(ClassLoader[]::new));
            }
            URLClassLoader addonClassLoader = new URLClassLoader(new URL[]{jarFile.toUri().toURL()}, parent);
            Class<?> entrypointClass = addonClassLoader.loadClass(addonInfo.getEntrypoint());
            Object instance = entrypointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            LoadedAddon loadedAddon2 = new LoadedAddon(addonInfo, jarFile, addonClassLoader, instance);
            this.loadedAddons.put(addonInfo.getId(), loadedAddon2);
            if (instance instanceof Runnable) {
                Runnable runnable = (Runnable)instance;
                runnable.run();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("There was an exception trying to initialize the addon!", e);
        }
    }
}

