/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.arguments;

import de.bluecolored.bluecommands.CommandParseException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.SimpleSuggestion;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluecommands.parsers.SimpleArgumentParser;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class StringSetArgumentParser
extends SimpleArgumentParser<CommandSource, String> {
    private final String typeName;
    private final Supplier<Set<String>> setSupplier;

    public StringSetArgumentParser(String typeName, Set<String> set) {
        this(typeName, () -> set);
    }

    public StringSetArgumentParser(String typeName, Supplier<Set<String>> setSupplier) {
        super(true, false);
        this.typeName = typeName;
        this.setSupplier = setSupplier;
    }

    @Override
    public String parse(CommandSource context, String string) throws CommandParseException {
        boolean hasValue = this.setSupplier.get().contains(string);
        if (!hasValue) {
            throw new CommandParseException("There is no %s for '%s'".formatted(this.typeName, string));
        }
        return string;
    }

    @Override
    public List<Suggestion> suggest(CommandSource context, InputReader input) {
        return this.setSupplier.get().stream().sorted().map(SimpleSuggestion::new).toList();
    }
}

