/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.mask;

import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.mask.MaskType;
import de.bluecolored.bluemap.core.map.mask.CombinedMask;
import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public abstract class MaskConfig {
    private String type = MaskType.BOX.getKey().getFormatted();
    private boolean subtract = false;

    public MaskType getMaskType() throws ConfigurationException {
        return MaskConfig.parseKey(MaskType.REGISTRY, this.type, "mask-type");
    }

    public abstract Mask createMask() throws ConfigurationException;

    public void addTo(CombinedMask combinedMask) throws ConfigurationException {
        Mask mask = this.createMask();
        combinedMask.add(mask, !this.subtract);
    }

    static <T extends Keyed> T parseKey(Registry<T> registry, String key, String typeName) throws ConfigurationException {
        T type = registry.get(Key.parse(key, "bluemap"));
        if (type == null) {
            throw new ConfigurationException("No " + typeName + " found for key: " + key + "!");
        }
        return type;
    }

    public boolean isSubtract() {
        return this.subtract;
    }

    @ConfigSerializable
    public static class Base
    extends MaskConfig {
        @Override
        public Mask createMask() {
            throw new UnsupportedOperationException();
        }
    }
}

