/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.common.rendermanager.MapSaveTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.TileUpdateStrategy;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.MapTileState;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class MapUpdatePreparationTask
implements MapRenderTask {
    private final BmMap map;
    @Nullable
    private final Vector2i center;
    @Nullable
    private final Integer radius;
    private final TileUpdateStrategy force;
    private final Consumer<MapUpdateTask> taskConsumer;
    private volatile boolean hasMoreWork;
    private volatile boolean cancelled;

    protected MapUpdatePreparationTask(@NonNull BmMap map, @Nullable Vector2i center, @Nullable Integer radius, TileUpdateStrategy force, @NonNull Consumer<MapUpdateTask> taskConsumer) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (taskConsumer == null) {
            throw new NullPointerException("taskConsumer is marked non-null but is null");
        }
        this.map = map;
        this.center = center;
        this.radius = radius;
        this.force = force != null ? force : TileUpdateStrategy.FORCE_NONE;
        this.taskConsumer = taskConsumer;
        this.hasMoreWork = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        MapUpdatePreparationTask mapUpdatePreparationTask = this;
        synchronized (mapUpdatePreparationTask) {
            if (!this.hasMoreWork) {
                return;
            }
            this.hasMoreWork = false;
        }
        if (this.cancelled) {
            return;
        }
        Collection<Vector2i> regions = this.findRegions();
        Collection<RenderTask> tasks = this.createTasks(regions);
        MapUpdateTask mapUpdateTask = new MapUpdateTask(this.map, tasks);
        if (this.cancelled) {
            return;
        }
        this.taskConsumer.accept(mapUpdateTask);
    }

    @Override
    public boolean hasMoreWork() {
        return this.hasMoreWork && !this.cancelled;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public String getDescription() {
        return "preparing map '%s' update".formatted(this.map.getId());
    }

    private Collection<RenderTask> createTasks(Collection<Vector2i> regions) {
        ArrayList<WorldRegionRenderTask> regionTasks = new ArrayList<WorldRegionRenderTask>(regions.size());
        regions.forEach(region -> regionTasks.add(new WorldRegionRenderTask(this.map, (Vector2i)region, this.force)));
        regionTasks.sort(WorldRegionRenderTask.defaultComparator(Vector2i.ZERO));
        ArrayList<RenderTask> tasks = new ArrayList<RenderTask>(regionTasks.size() + 2);
        tasks.add(new MapSaveTask(this.map));
        tasks.addAll(regionTasks);
        tasks.add(new MapSaveTask(this.map));
        return tasks;
    }

    private Collection<Vector2i> findRegions() {
        Predicate<Vector2i> regionRadiusFilter;
        World world = this.map.getWorld();
        Grid regionGrid = world.getRegionGrid();
        Predicate<Vector2i> regionBoundsFilter = this.map.getMapSettings().getCellRenderBoundariesFilter(regionGrid, true);
        if (this.center == null || this.radius == null || this.radius < 0) {
            regionRadiusFilter = r -> true;
        } else {
            Vector2i halfCell = regionGrid.getGridSize().div(2);
            long increasedRadiusSquared = (long)Math.pow((double)this.radius.intValue() + Math.ceil(halfCell.length()), 2.0);
            regionRadiusFilter = r -> {
                Vector2i min2 = regionGrid.getCellMin((Vector2i)r);
                Vector2i regionCenter = min2.add(halfCell);
                return regionCenter.toLong().distanceSquared(this.center.toLong()) <= increasedRadiusSquared;
            };
        }
        HashSet<Vector2i> regions = new HashSet<Vector2i>();
        world.listRegions().stream().filter(regionBoundsFilter).filter(regionRadiusFilter).forEach(regions::add);
        if (this.map.getMapSettings().isCheckForRemovedRegions()) {
            Grid tileGrid = this.map.getHiresModelManager().getTileGrid();
            Grid cellGrid = MapTileState.GRID.multiply(tileGrid);
            try (Stream<GridStorage.Cell> stream = this.map.getStorage().tileState().stream();){
                stream.filter(c -> {
                    try (CompressedInputStream in = c.read();){
                        TileState[] states;
                        if (in == null) {
                            boolean bl = false;
                            return bl;
                        }
                        for (TileState state : states = TileInfoRegion.loadPalette(in.decompress())) {
                            if (state == TileState.UNKNOWN || state == TileState.NOT_GENERATED) continue;
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException ignore) {
                        return true;
                    }
                }).map(c -> new Vector2i(c.getX(), c.getZ())).flatMap(v -> cellGrid.getIntersecting((Vector2i)v, regionGrid).stream()).filter(regionRadiusFilter).forEach(regions::add);
            }
            catch (IOException ex) {
                Logger.global.logError("Failed to load map tile state!", ex);
            }
        }
        return regions;
    }

    public static MapUpdatePreparationTask updateMap(BmMap map, RenderManager renderManager) {
        return MapUpdatePreparationTask.builder().map(map).taskConsumer(renderManager::scheduleRenderTask).build();
    }

    public static MapUpdatePreparationTask updateMap(BmMap map, TileUpdateStrategy force, RenderManager renderManager) {
        return MapUpdatePreparationTask.builder().map(map).force(force).taskConsumer(renderManager::scheduleRenderTask).build();
    }

    public static MapUpdatePreparationTaskBuilder builder() {
        return new MapUpdatePreparationTaskBuilder();
    }

    @Override
    public BmMap getMap() {
        return this.map;
    }

    public static class MapUpdatePreparationTaskBuilder {
        private BmMap map;
        private Vector2i center;
        private Integer radius;
        private TileUpdateStrategy force;
        private Consumer<MapUpdateTask> taskConsumer;

        MapUpdatePreparationTaskBuilder() {
        }

        public MapUpdatePreparationTaskBuilder map(@NonNull BmMap map) {
            if (map == null) {
                throw new NullPointerException("map is marked non-null but is null");
            }
            this.map = map;
            return this;
        }

        public MapUpdatePreparationTaskBuilder center(@Nullable Vector2i center) {
            this.center = center;
            return this;
        }

        public MapUpdatePreparationTaskBuilder radius(@Nullable Integer radius) {
            this.radius = radius;
            return this;
        }

        public MapUpdatePreparationTaskBuilder force(TileUpdateStrategy force) {
            this.force = force;
            return this;
        }

        public MapUpdatePreparationTaskBuilder taskConsumer(@NonNull Consumer<MapUpdateTask> taskConsumer) {
            if (taskConsumer == null) {
                throw new NullPointerException("taskConsumer is marked non-null but is null");
            }
            this.taskConsumer = taskConsumer;
            return this;
        }

        public MapUpdatePreparationTask build() {
            return new MapUpdatePreparationTask(this.map, this.center, this.radius, this.force, this.taskConsumer);
        }

        public String toString() {
            return "MapUpdatePreparationTask.MapUpdatePreparationTaskBuilder(map=" + String.valueOf(this.map) + ", center=" + String.valueOf(this.center) + ", radius=" + this.radius + ", force=" + String.valueOf(this.force) + ", taskConsumer=" + String.valueOf(this.taskConsumer) + ")";
        }
    }
}

