/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.intellij.lang.annotations.Language;

public class RoutingRequestHandler
implements HttpRequestHandler {
    private final Deque<Route> routes = new ConcurrentLinkedDeque<Route>();

    public void register(@Language(value="RegExp") String pattern, HttpRequestHandler handler) {
        this.register(Pattern.compile(pattern), handler);
    }

    public void register(@Language(value="RegExp") String pattern, String replacementRoute, HttpRequestHandler handler) {
        this.register(Pattern.compile(pattern), replacementRoute, handler);
    }

    public void register(Pattern pattern, HttpRequestHandler handler) {
        this.routes.addFirst(new Route(pattern, handler));
    }

    public void register(Pattern pattern, String replacementRoute, HttpRequestHandler handler) {
        this.routes.addFirst(new Route(pattern, replacementRoute, handler));
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        String path = request.getPath();
        if (path == null) {
            return new HttpResponse(HttpStatusCode.BAD_REQUEST);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.isEmpty()) {
            path = "/";
        }
        for (Route route : this.routes) {
            Matcher matcher = route.getRoutePattern().matcher(path);
            if (!matcher.matches()) continue;
            request.setPath(matcher.replaceFirst(route.getReplacementRoute()));
            return route.getHandler().handle(request);
        }
        return new HttpResponse(HttpStatusCode.BAD_REQUEST);
    }

    public Deque<Route> getRoutes() {
        return this.routes;
    }

    public static class Route {
        @NonNull
        private Pattern routePattern;
        @NonNull
        private String replacementRoute;
        @NonNull
        private HttpRequestHandler handler;

        public Route(@NonNull Pattern routePattern, @NonNull HttpRequestHandler handler) {
            if (routePattern == null) {
                throw new NullPointerException("routePattern is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            this.routePattern = routePattern;
            this.replacementRoute = "$0";
            this.handler = handler;
        }

        public Route(@NonNull Pattern routePattern, @NonNull String replacementRoute, @NonNull HttpRequestHandler handler) {
            if (routePattern == null) {
                throw new NullPointerException("routePattern is marked non-null but is null");
            }
            if (replacementRoute == null) {
                throw new NullPointerException("replacementRoute is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            this.routePattern = routePattern;
            this.replacementRoute = replacementRoute;
            this.handler = handler;
        }

        @NonNull
        public Pattern getRoutePattern() {
            return this.routePattern;
        }

        @NonNull
        public String getReplacementRoute() {
            return this.replacementRoute;
        }

        @NonNull
        public HttpRequestHandler getHandler() {
            return this.handler;
        }

        public void setRoutePattern(@NonNull Pattern routePattern) {
            if (routePattern == null) {
                throw new NullPointerException("routePattern is marked non-null but is null");
            }
            this.routePattern = routePattern;
        }

        public void setReplacementRoute(@NonNull String replacementRoute) {
            if (replacementRoute == null) {
                throw new NullPointerException("replacementRoute is marked non-null but is null");
            }
            this.replacementRoute = replacementRoute;
        }

        public void setHandler(@NonNull HttpRequestHandler handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            this.handler = handler;
        }
    }
}

