/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql.commandset;

import de.bluecolored.bluemap.core.storage.sql.Database;
import de.bluecolored.bluemap.core.storage.sql.commandset.AbstractCommandSet;
import org.intellij.lang.annotations.Language;

public class MySQLCommandSet
extends AbstractCommandSet {
    public MySQLCommandSet(Database db) {
        super(db);
    }

    @Override
    @Language(value="mysql")
    public String listExistingTablesStatement() {
        return "SELECT TABLE_NAME\nFROM information_schema.tables\nWHERE table_schema = DATABASE()\n  AND table_type = 'BASE TABLE'\n";
    }

    @Override
    @Language(value="mysql")
    public String createMapTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_map` (\n `id` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,\n `map_id` VARCHAR(190) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE INDEX `map_id` (`map_id`)\n) COLLATE 'utf8mb4_bin'\n";
    }

    @Override
    @Language(value="mysql")
    public String createCompressionTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_compression` (\n `id` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,\n `key` VARCHAR(190) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE INDEX `key` (`key`)\n) COLLATE 'utf8mb4_bin'\n";
    }

    @Override
    @Language(value="mysql")
    public String createItemStorageTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_item_storage` (\n `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,\n `key` VARCHAR(190) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE INDEX `key` (`key`)\n) COLLATE 'utf8mb4_bin'\n";
    }

    @Override
    @Language(value="mysql")
    public String createItemStorageDataTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_item_storage_data` (\n `map` SMALLINT UNSIGNED NOT NULL,\n `storage` INT UNSIGNED NOT NULL,\n `compression` SMALLINT UNSIGNED NOT NULL,\n `data` LONGBLOB NOT NULL,\n PRIMARY KEY (`map`, `storage`),\n CONSTRAINT `fk_bluemap_item_map`\n  FOREIGN KEY (`map`)\n  REFERENCES `bluemap_map` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_item`\n  FOREIGN KEY (`storage`)\n  REFERENCES `bluemap_item_storage` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_item_compression`\n  FOREIGN KEY (`compression`)\n  REFERENCES `bluemap_compression` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE\n) COLLATE 'utf8mb4_bin'\n";
    }

    @Override
    @Language(value="mysql")
    public String createGridStorageTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_grid_storage` (\n `id` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,\n `key` VARCHAR(190) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE INDEX `key` (`key`)\n) COLLATE 'utf8mb4_bin'\n";
    }

    @Override
    @Language(value="mysql")
    public String createGridStorageDataTableStatement() {
        return "CREATE TABLE IF NOT EXISTS `bluemap_grid_storage_data` (\n `map` SMALLINT UNSIGNED NOT NULL,\n `storage` SMALLINT UNSIGNED NOT NULL,\n `x` INT NOT NULL,\n `z` INT NOT NULL,\n `compression` SMALLINT UNSIGNED NOT NULL,\n `data` LONGBLOB NOT NULL,\n PRIMARY KEY (`map`, `storage`, `x`, `z`),\n CONSTRAINT `fk_bluemap_grid_map`\n  FOREIGN KEY (`map`)\n  REFERENCES `bluemap_map` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_grid`\n  FOREIGN KEY (`storage`)\n  REFERENCES `bluemap_grid_storage` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE,\n CONSTRAINT `fk_bluemap_grid_compression`\n  FOREIGN KEY (`compression`)\n  REFERENCES `bluemap_compression` (`id`)\n  ON UPDATE RESTRICT\n  ON DELETE CASCADE\n) COLLATE 'utf8mb4_bin'\n";
    }

    @Override
    @Language(value="mysql")
    public String itemStorageWriteStatement() {
        return "REPLACE\nINTO `bluemap_item_storage_data` (`map`, `storage`, `compression`, `data`)\nVALUES (?, ?, ?, ?)\n";
    }

    @Override
    @Language(value="mysql")
    public String itemStorageReadStatement() {
        return "SELECT `data`\nFROM `bluemap_item_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String itemStorageDeleteStatement() {
        return "DELETE\nFROM `bluemap_item_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String itemStorageHasStatement() {
        return "SELECT COUNT(*) > 0\nFROM `bluemap_item_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStorageWriteStatement() {
        return "REPLACE\nINTO `bluemap_grid_storage_data` (`map`, `storage`, `x`, `z`, `compression`, `data`)\nVALUES (?, ?, ?, ?, ?, ?)\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStorageReadStatement() {
        return "SELECT `data`\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `x` = ?\nAND `z` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStorageDeleteStatement() {
        return "DELETE\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `x` = ?\nAND `z` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStorageHasStatement() {
        return "SELECT COUNT(*) > 0\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `x` = ?\nAND `z` = ?\nAND `compression` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStorageListStatement() {
        return "SELECT `x`, `z`\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nAND `storage` = ?\nAND `compression` = ?\nLIMIT ? OFFSET ?\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStorageCountMapItemsStatement() {
        return "SELECT COUNT(*)\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String gridStoragePurgeMapStatement() {
        return "DELETE\nFROM `bluemap_grid_storage_data`\nWHERE `map` = ?\nLIMIT ?\n";
    }

    @Override
    @Language(value="mysql")
    public String purgeMapStatement() {
        return "DELETE\nFROM `bluemap_map`\nWHERE `id` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String hasMapStatement() {
        return "SELECT COUNT(*) > 0\nFROM `bluemap_map` m\nWHERE m.`map_id` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String listMapIdsStatement() {
        return "SELECT `map_id`\nFROM `bluemap_map` m\nLIMIT ? OFFSET ?\n";
    }

    @Override
    @Language(value="mysql")
    public String findMapKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_map`\nWHERE map_id = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String createMapKeyStatement() {
        return "INSERT\nINTO `bluemap_map` (`map_id`)\nVALUES (?)\n";
    }

    @Override
    @Language(value="mysql")
    public String findCompressionKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_compression`\nWHERE `key` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String createCompressionKeyStatement() {
        return "INSERT\nINTO `bluemap_compression` (`key`)\nVALUES (?)\n";
    }

    @Override
    @Language(value="mysql")
    public String findItemStorageKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_item_storage`\nWHERE `key` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String createItemStorageKeyStatement() {
        return "INSERT\nINTO `bluemap_item_storage` (`key`)\nVALUES (?)\n";
    }

    @Override
    @Language(value="mysql")
    public String findGridStorageKeyStatement() {
        return "SELECT `id`\nFROM `bluemap_grid_storage`\nWHERE `key` = ?\n";
    }

    @Override
    @Language(value="mysql")
    public String createGridStorageKeyStatement() {
        return "INSERT\nINTO `bluemap_grid_storage` (`key`)\nVALUES (?)\n";
    }
}

