/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.nbt;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TypeAdapter;
import de.bluecolored.bluenbt.TypeToken;
import de.bluecolored.bluenbt.adapter.ArrayAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;

public class PalettedArrayAdapter<T>
implements TypeAdapter<T[]> {
    private final Class<T> type;
    private final TypeAdapter<T[]> paletteAdapter;

    public PalettedArrayAdapter(BlueNBT blueNBT, Class<T> type) {
        this.type = type;
        this.paletteAdapter = ArrayAdapterFactory.INSTANCE.create(TypeToken.array(type), blueNBT).orElseThrow();
    }

    @Override
    public T[] read(NBTReader reader) throws IOException {
        reader.beginCompound();
        Object[] palette = null;
        byte[] data = null;
        block8: while (reader.hasNext()) {
            String name;
            switch (name = reader.name()) {
                case "palette": {
                    palette = (Object[])this.paletteAdapter.read(reader);
                    continue block8;
                }
                case "data": {
                    data = reader.nextArrayAsByteArray();
                    continue block8;
                }
            }
            reader.skip();
        }
        reader.endCompound();
        if (palette == null || palette.length == 0) {
            throw new IOException("Missing or empty palette");
        }
        if (data == null) {
            return (Object[])Array.newInstance(this.type, 0);
        }
        Object[] result = (Object[])Array.newInstance(this.type, data.length);
        for (int i = 0; i < data.length; ++i) {
            byte index = data[i];
            if (index >= palette.length) {
                throw new IOException("Palette (size: " + palette.length + ") does not contain entry-index (" + index + ")");
            }
            result[i] = palette[data[i]];
        }
        return result;
    }

    @Override
    public void write(T[] value, NBTWriter writer) throws IOException {
        HashMap<Object, Byte> paletteMap = new HashMap<Object, Byte>();
        byte[] data = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            byte index;
            data[i] = index = paletteMap.computeIfAbsent(value[i], v -> (byte)paletteMap.size()).byteValue();
        }
        Object[] palette = (Object[])Array.newInstance(this.type, paletteMap.size());
        paletteMap.forEach((k, v) -> {
            palette[v.byteValue()] = k;
        });
        writer.beginCompound();
        writer.name("palette");
        this.paletteAdapter.write(palette, writer);
        writer.name("data").value(data);
        writer.endCompound();
    }

    public PalettedArrayAdapter(Class<T> type, TypeAdapter<T[]> paletteAdapter) {
        this.type = type;
        this.paletteAdapter = paletteAdapter;
    }
}

