/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.nbt;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeAdapter;
import java.io.IOException;

public class RegistryAdapter<T extends Keyed>
implements TypeAdapter<T> {
    private final Registry<T> registry;
    private final String defaultNamespace;
    private final T fallback;

    @Override
    public T read(NBTReader reader) throws IOException {
        Key key = Key.parse(reader.nextString(), this.defaultNamespace);
        T value = this.registry.get(key);
        if (value != null) {
            return value;
        }
        Logger.global.noFloodWarning("unknown-registry-key-" + key.getFormatted(), "Failed to find registry-entry for key: " + String.valueOf(key));
        return this.fallback;
    }

    @Override
    public void write(T value, NBTWriter writer) throws IOException {
        writer.value(value.getKey().getFormatted());
    }

    @Override
    public TagType type() {
        return TagType.STRING;
    }

    public RegistryAdapter(Registry<T> registry, String defaultNamespace, T fallback) {
        this.registry = registry;
        this.defaultNamespace = defaultNamespace;
        this.fallback = fallback;
    }
}

