/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.WatchService;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.Region;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface World {
    public String getId();

    public String getName();

    public DimensionType getDimensionType();

    public Grid getChunkGrid();

    public Grid getRegionGrid();

    public Chunk getChunkAtBlock(int var1, int var2);

    public Chunk getChunk(int var1, int var2);

    public Region<Chunk> getRegion(int var1, int var2);

    public Collection<Vector2i> listRegions();

    default public WatchService<Vector2i> createRegionWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void preloadRegionChunks(int x, int z) {
        this.preloadRegionChunks(x, z, pos -> true);
    }

    public void preloadRegionChunks(int var1, int var2, Predicate<Vector2i> var3);

    public void invalidateChunkCache();

    public void invalidateChunkCache(int var1, int var2);

    public void iterateEntities(int var1, int var2, int var3, int var4, Consumer<Entity> var5);

    public static String id(Path worldFolder, Key dimension) {
        Path workingDir;
        if ((worldFolder = worldFolder.toAbsolutePath().normalize()).startsWith(workingDir = Path.of("", new String[0]).toAbsolutePath().normalize())) {
            worldFolder = workingDir.relativize(worldFolder);
        }
        return String.valueOf(worldFolder) + "#" + dimension.getFormatted();
    }
}

