/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;

public class Vector3iDeserializer
implements TypeDeserializer<Vector3i> {
    @Override
    public Vector3i read(NBTReader reader) throws IOException {
        TagType tag;
        TagType tagType = tag = reader.peek();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INT_ARRAY", "LONG_ARRAY", "BYTE_ARRAY", "LIST", "COMPOUND"}, (TagType)tagType, n)) {
            case 0, 1, 2 -> {
                long[] values = reader.nextArrayAsLongArray();
                if (values.length != 3) {
                    throw new IllegalStateException("Unexpected array length: " + values.length);
                }
                yield new Vector3i(values[0], values[1], values[2]);
            }
            case 3 -> {
                reader.beginList();
                Vector3i value = new Vector3i(reader.nextInt(), reader.nextInt(), reader.nextInt());
                reader.endList();
                yield value;
            }
            case 4 -> {
                int x = 0;
                int y = 0;
                int z = 0;
                reader.beginCompound();
                block15: while (reader.peek() != TagType.END) {
                    switch (reader.name()) {
                        case "x": {
                            x = reader.nextInt();
                            continue block15;
                        }
                        case "y": {
                            y = reader.nextInt();
                            continue block15;
                        }
                        case "z": {
                            z = reader.nextInt();
                            continue block15;
                        }
                    }
                    reader.skip();
                }
                reader.endCompound();
                yield new Vector3i(x, y, z);
            }
            default -> throw new IllegalStateException("Unexpected tag-type: " + String.valueOf((Object)tag));
        };
    }
}

