/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.sponge;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.sponge.SpongePlugin;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.server.ServerWorld;

public class SpongeCommandSource
implements CommandSource {
    private final Audience audience;
    private final Subject subject;

    public SpongeCommandSource(Audience audience, Subject subject) {
        this.subject = subject;
        this.audience = audience;
    }

    @Override
    public void sendMessage(Component text) {
        if (TextFormat.lineCount(text) > 1) {
            text = ((TextComponent)Component.newline().append(text)).appendNewline();
        }
        this.audience.sendMessage(text.compact());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.subject.hasPermission(permission);
    }

    @Override
    public Optional<Vector3d> getPosition() {
        Audience audience = this.audience;
        if (audience instanceof Locatable) {
            Locatable locatable = (Locatable)audience;
            return Optional.of(SpongePlugin.fromSpongeVector(locatable.location().position()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<de.bluecolored.bluemap.common.serverinterface.ServerWorld> getWorld() {
        Audience audience = this.audience;
        if (audience instanceof Locatable) {
            Locatable locatable = (Locatable)audience;
            ServerWorld world = (ServerWorld)locatable.serverLocation().world();
            if (world == null) {
                return Optional.empty();
            }
            return Optional.of(SpongePlugin.getInstance().getServerWorld(world));
        }
        return Optional.empty();
    }
}

