/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.sponge;

import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.LiteralCommand;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluemap.common.commands.CommandExecutor;
import de.bluecolored.bluemap.common.commands.Commands;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.sponge.SpongeCommandSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.ArgumentReader;

public class SpongeCommands {
    private final Command<CommandSource, Object> commands;
    private final CommandExecutor commandExecutor;

    public SpongeCommands(Plugin plugin) {
        this.commands = Commands.create(plugin);
        this.commandExecutor = new CommandExecutor(plugin);
    }

    public Collection<SpongeCommandProxy> getRootCommands() {
        return List.of(new SpongeCommandProxy(((LiteralCommand)this.commands).getLiteral()));
    }

    public class SpongeCommandProxy
    implements Command.Raw {
        private final String label;

        protected SpongeCommandProxy(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public CommandResult process(CommandCause cause, ArgumentReader.Mutable arguments) {
            SpongeCommandSource context;
            ParseResult<CommandSource, Object> result;
            CommandExecutor.ExecutionResult executionResult;
            Object input = this.label;
            if (!arguments.input().isEmpty()) {
                input = (String)input + " " + arguments.input();
            }
            if ((executionResult = SpongeCommands.this.commandExecutor.execute(result = SpongeCommands.this.commands.parse((CommandSource)(context = new SpongeCommandSource(cause.audience(), cause.subject())), (String)input))).parseFailure()) {
                Optional<ParseFailure> failure = result.getFailures().stream().max(Comparator.comparing(ParseFailure::getPosition));
                if (failure.isPresent()) {
                    context.sendMessage(Component.text((String)failure.get().getReason()).color(TextFormat.NEGATIVE_COLOR));
                } else {
                    context.sendMessage(Component.text((String)"Unknown command!").color(TextFormat.NEGATIVE_COLOR));
                }
                return CommandResult.builder().result(0).build();
            }
            return CommandResult.builder().result(executionResult.resultCode()).build();
        }

        public List<CommandCompletion> complete(CommandCause cause, ArgumentReader.Mutable arguments) {
            String input = this.label + " " + arguments.input();
            int position = input.lastIndexOf(32) + 1;
            SpongeCommandSource context = new SpongeCommandSource(cause.audience(), cause.subject());
            ParseResult<CommandSource, Object> result = SpongeCommands.this.commands.parse((CommandSource)context, input);
            ArrayList<String> completions = new ArrayList<String>();
            for (ParseFailure<CommandSource, Object> failure : result.getFailures()) {
                if (failure.getPosition() != position) continue;
                for (Suggestion suggestion : failure.getSuggestions()) {
                    completions.add(suggestion.getString());
                }
            }
            return completions.stream().sorted(String::compareToIgnoreCase).map(CommandCompletion::of).toList();
        }

        public boolean canExecute(CommandCause cause) {
            return true;
        }

        public Optional<Component> shortDescription(CommandCause cause) {
            return Optional.empty();
        }

        public Optional<Component> extendedDescription(CommandCause cause) {
            return Optional.empty();
        }

        public Component usage(CommandCause cause) {
            return Component.empty();
        }
    }
}

