/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.sponge;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.serverinterface.Gamemode;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.sponge.SpongePlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.world.LightTypes;

public class SpongePlayer
extends Player {
    private static final Map<GameMode, Gamemode> GAMEMODE_MAP = new HashMap<GameMode, Gamemode>(5);
    private final UUID uuid;
    private Text name;
    private ServerWorld world;
    private Vector3d position;
    private Vector3d rotation;
    private int skyLight;
    private int blockLight;
    private boolean sneaking;
    private boolean invisible;
    private boolean vanished;
    private Gamemode gamemode;

    public SpongePlayer(ServerPlayer player) {
        this.uuid = player.uniqueId();
        this.update(player);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Text getName() {
        return this.name;
    }

    @Override
    public ServerWorld getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public Vector3d getRotation() {
        return this.rotation;
    }

    @Override
    public int getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getBlockLight() {
        return this.blockLight;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public boolean isVanished() {
        return this.vanished;
    }

    @Override
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void update() {
        ServerPlayer player = Sponge.server().player(this.uuid).orElse(null);
        if (player == null) {
            return;
        }
        this.update(player);
    }

    private void update(ServerPlayer player) {
        this.gamemode = GAMEMODE_MAP.get(player.gameMode().get());
        if (this.gamemode == null) {
            this.gamemode = Gamemode.SURVIVAL;
        }
        boolean invis = false;
        Optional effects = player.get(Keys.POTION_EFFECTS);
        if (effects.isPresent()) {
            for (PotionEffect effect : (List)effects.get()) {
                if (!effect.type().equals(PotionEffectTypes.INVISIBILITY.get()) || effect.duration().ticks() <= 0L) continue;
                invis = true;
            }
        }
        this.invisible = invis;
        this.vanished = player.get(Keys.VANISH_STATE).orElse(VanishState.unvanished()).invisible();
        this.name = Text.of(player.name());
        this.position = SpongePlugin.fromSpongeVector(player.position());
        this.rotation = SpongePlugin.fromSpongeVector(player.rotation());
        this.sneaking = player.get(Keys.IS_SNEAKING).orElse(false);
        this.skyLight = player.world().light((Supplier)LightTypes.SKY, player.blockPosition());
        this.blockLight = player.world().light((Supplier)LightTypes.BLOCK, player.blockPosition());
        this.world = SpongePlugin.getInstance().getServerWorld(player.world());
    }

    static {
        GAMEMODE_MAP.put((GameMode)GameModes.ADVENTURE.get(), Gamemode.ADVENTURE);
        GAMEMODE_MAP.put((GameMode)GameModes.SURVIVAL.get(), Gamemode.SURVIVAL);
        GAMEMODE_MAP.put((GameMode)GameModes.CREATIVE.get(), Gamemode.CREATIVE);
        GAMEMODE_MAP.put((GameMode)GameModes.SPECTATOR.get(), Gamemode.SPECTATOR);
    }
}

